/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.misc;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapreduce.Reducer;

public class PredatoryJournalsReducer
extends Reducer<Text, ImmutableBytesWritable, Text, Text> {
    private static final Log log = LogFactory.getLog(PredatoryJournalsReducer.class);
    private static final String PREDATORY_JOURNALS = "Predatory Journal Counters";
    private static final String PUB_CHECKS = "Publication Counters";
    private Text keyOut = new Text();
    private Text valueOut = new Text();

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            int count = 0;
            String dsName = "";
            OafProtos.Oaf oaf = null;
            for (ImmutableBytesWritable ibw : values) {
                byte[] data = ibw.copyBytes();
                oaf = this.parseOaf(data);
                if (oaf != null) {
                    dsName = oaf.getEntity().getDatasource().getMetadata().getOfficialname().getValue();
                    continue;
                }
                int one = Bytes.toInt((byte[])data);
                if (one != 1) {
                    throw new JobTracker.IllegalStateException("woops unexpected number, got " + one);
                }
                count += one;
            }
            if (count > 0 && oaf != null) {
                this.valueOut.set(String.format("\"%s\", %s", dsName.replaceAll(",", " "), count));
                context.write((Object)this.keyOut, (Object)this.valueOut);
                context.getCounter(PREDATORY_JOURNALS, "journals").increment((long)count);
            }
            if (oaf != null && count == 0) {
                context.getCounter(PUB_CHECKS, "pubs from journals not linked to projects").increment(1L);
            }
            if (oaf == null && count > 0) {
                context.getCounter(PUB_CHECKS, "pubs from non-journal and linked to projects").increment((long)count);
            }
        }
        catch (Exception e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private OafProtos.Oaf parseOaf(byte[] data) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }
}

