package eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.datasource;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult.PropagationProjectToResultReducer;
import eu.dnetlib.data.proto.OafProtos;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;

import java.io.IOException;
import java.util.List;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.COUNTER_PROPAGATION;
import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.REL_TYPE_ORGANIZATION;

public class PropagationProductToOrganizationReducer extends TableReducer<InstOrgKey, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationProjectToResultReducer.class); // NOPMD by marko on 11/24/08 5:02 PM
    private ImmutableBytesWritable keyOut;


    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new ImmutableBytesWritable();
    }


    @Override
    protected void reduce(InstOrgKey key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
        ResultIterator rh = null;
        try {
            rh = new ResultOrganizationIterator(values, key.getKeyType().get());
        } catch (NotValidResultSequenceException e) {
            context.getCounter(COUNTER_PROPAGATION, e.getMessage()).increment(1);
            return;
        }
        while (rh.hasNext()) {
            List<OafProtos.Oaf> oafList = rh.next();
            for (OafProtos.Oaf oaf : oafList) {
                final String source = oaf.getRel().getSource();
                final Put put = new Put(Bytes.toBytes(source)).add(Bytes.toBytes(REL_TYPE_ORGANIZATION + oaf.getRel().getRelClass()),Bytes.toBytes(oaf.getRel().getTarget()),oaf.toByteArray());
                keyOut.set(Bytes.toBytes(source));

                context.write(keyOut, put);
            }
            context.getCounter(COUNTER_PROPAGATION, "Added result to organizationtoresult").increment(oafList.size()/2);
        }

    }

}
