/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.add;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class AdditionMapper
extends TableMapper<Text, Text> {
    private Text outKey;
    private Text outValue;
    private Map<String, Set<EntityInfo>> projectOrganization;
    private Map<String, Set<EntityInfo>> organizationDatasource;
    private Set<String> organizationPrefixBlacklist = Sets.newHashSet();
    private Set<String> dsTypeWhitelist = Sets.newHashSet();

    protected void setup(Mapper.Context context) throws IOException {
        this.organizationPrefixBlacklist = Sets.newHashSet((Object[])new String[]{"nsf_________"});
        this.dsTypeWhitelist.addAll(OafHbaseUtils.getPropertyValues(context, "broker.datasource.type.whitelist"));
        this.projectOrganization = this.getRelMap(context, "20", "organization", "projectOrganization_participation_isParticipant", this.organizationPrefixBlacklist);
        this.organizationDatasource = this.getRelMap(context, "10", "datasource", "datasourceOrganization_provision_provides", this.dsTypeWhitelist);
        this.outKey = new Text("");
        this.outValue = new Text();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)"result"));
            byte[] bodyB = (byte[])map.get(Bytes.toBytes((String)"body"));
            if (MapUtils.isEmpty((Map)map) || bodyB == null) {
                context.getCounter("result", "empty body").increment(1L);
                return;
            }
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])bodyB);
            if (oaf.getDataInfo().getDeletedbyinference()) {
                context.getCounter("result", "deletedbyinference = true").increment(1L);
                return;
            }
            HashSet currentDatasourceIds = Sets.newHashSet(OafHbaseUtils.listKeys(oaf.getEntity().getCollectedfromList()));
            NavigableMap resultProject = value.getFamilyMap(Bytes.toBytes((String)"resultProject_outcome_isProducedBy"));
            if (!MapUtils.isEmpty((Map)resultProject)) {
                for (String projectId : this.asStringID(resultProject.keySet())) {
                    Set<EntityInfo> organizations = this.projectOrganization.get(projectId);
                    if (organizations == null || organizations.isEmpty()) continue;
                    for (EntityInfo organization : organizations) {
                        Set<EntityInfo> datasources = this.organizationDatasource.get(organization.getId());
                        if (datasources == null || datasources.isEmpty()) continue;
                        for (EntityInfo datasource : datasources) {
                            if (currentDatasourceIds.contains(datasource.getId())) continue;
                            float trust = RandomUtils.nextFloat();
                            OpenAireEventPayload payload = OpenAireEventPayloadFactory.fromOAF(oaf.getEntity(), oaf.getEntity(), trust);
                            EventMessage event = EventFactory.asEvent(oaf.getEntity(), Topic.ADD_BY_PROJECT, payload, datasource.getId(), datasource.getName(), trust);
                            this.emit(event, context);
                            context.getCounter("event", Topic.ADD_BY_PROJECT.getValue()).increment(1L);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void emit(EventMessage e, Mapper.Context context) throws IOException, InterruptedException {
        this.outValue.set(e.toString());
        context.write((Object)this.outKey, (Object)this.outValue);
    }

    private Iterable<String> asStringID(Iterable<byte[]> in) {
        return Iterables.transform(in, (Function)new Function<byte[], String>(){

            public String apply(byte[] input) {
                return AdditionMapper.this.getID(new String(input));
            }
        });
    }

    private Map<String, Set<EntityInfo>> getRelMap(Mapper.Context context, String prefixFilter, String entity, String columnFamily, Set<String> filter) throws IOException {
        System.out.println(String.format("loading %s, %s", entity, columnFamily));
        HashMap out = Maps.newHashMap();
        String tableName = context.getConfiguration().get("hbase.mapred.inputtable");
        System.out.println(String.format("table name: '%s'", tableName));
        try (HTable table = new HTable(context.getConfiguration(), tableName);
             ResultScanner res = this.scanTable(table, prefixFilter, entity, columnFamily);){
            for (Result r : res) {
                byte[] bodyB = r.getValue(Bytes.toBytes((String)entity), Bytes.toBytes((String)"body"));
                if (bodyB == null) {
                    context.getCounter("missing body", entity).increment(1L);
                    continue;
                }
                OafProtos.OafEntity oafEntity = OafDecoder.decode((byte[])bodyB).getEntity();
                EntityInfo kv = this.getEntityInfo(oafEntity, filter);
                if (kv == null) continue;
                NavigableMap relMap = r.getFamilyMap(Bytes.toBytes((String)columnFamily));
                if (MapUtils.isNotEmpty((Map)relMap)) {
                    for (String id : this.asStringID(relMap.keySet())) {
                        if (!out.containsKey(id)) {
                            out.put(id, new HashSet());
                        }
                        ((Set)out.get(id)).add(kv);
                    }
                    continue;
                }
                context.getCounter("skipped", entity).increment(1L);
            }
        }
        System.out.println(String.format("loaded map for %s, %s, size: %s", entity, columnFamily, out.size()));
        return out;
    }

    private EntityInfo getEntityInfo(OafProtos.OafEntity entity, Set<String> filter) {
        String id = this.getID(entity.getId());
        switch (entity.getType()) {
            case datasource: {
                String dsType = entity.getDatasource().getMetadata().getDatasourcetype().getClassid();
                if (!filter.contains(dsType)) {
                    return null;
                }
                return new EntityInfo(id, entity.getDatasource().getMetadata().getOfficialname().getValue());
            }
            case organization: {
                if (filter.contains(this.prefix(id))) {
                    return null;
                }
                return new EntityInfo(id, entity.getOrganization().getMetadata().getLegalname().getValue());
            }
        }
        throw new IllegalArgumentException("invalid entity: " + entity);
    }

    private ResultScanner scanTable(HTable table, String prefixFilter, String entity, String columnFamily) throws IOException {
        Scan scan = new Scan();
        FilterList fl = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        fl.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)prefixFilter)));
        scan.setFilter((Filter)fl);
        scan.addFamily(Bytes.toBytes((String)entity));
        scan.addFamily(Bytes.toBytes((String)columnFamily));
        return table.getScanner(scan);
    }

    private String getID(String s) {
        return StringUtils.substringAfter((String)s, (String)"|");
    }

    private String prefix(String s) {
        return StringUtils.substringBefore((String)s, (String)"::");
    }

    class EntityInfo {
        private String id;
        private String name;

        public EntityInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getId().equals(obj);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

