/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class AbstractEnrichmentMapper
extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
    protected ImmutableBytesWritable outValue;
    protected ImmutableBytesWritable outKey;

    protected abstract String counterGroup();

    protected void setup(Mapper.Context context) {
        this.outKey = new ImmutableBytesWritable();
        this.outValue = new ImmutableBytesWritable();
    }

    protected void emit(Mapper.Context context, byte[] key, byte[] value, String entityType) {
        this.outKey.set(key);
        this.outValue.set(value);
        try {
            context.write((Object)this.outKey, (Object)this.outValue);
            context.getCounter(this.counterGroup(), "entity type: " + entityType).increment(1L);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected byte[] getEmitKey(Mapper.Context context, ImmutableBytesWritable key, Map<byte[], byte[]> mergedIn) {
        if (MapUtils.isNotEmpty(mergedIn)) {
            context.getCounter(TypeProtos.Type.result.name(), DedupProtos.Dedup.RelName.isMergedIn.name()).increment(1L);
            return mergedIn.keySet().iterator().next();
        }
        return key.copyBytes();
    }
}

