/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.communitytoresult;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.communitytoresult.CommunityList;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class CommunityToResultMapper
extends TableMapper<Text, Text> {
    private Text keyOut;
    private Text valueOut;
    private String[] sem_rels;
    private String trust;
    CommunityList idCommunityList;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.idCommunityList = (CommunityList)new Gson().fromJson(context.getConfiguration().get("community.id.list"), CommunityList.class);
        this.keyOut = new Text();
        this.valueOut = new Text();
        this.sem_rels = context.getConfiguration().getStrings("propagatetocommunity.semanticrelations", PropagationConstants.DEFAULT_COMMUNITY_RELATION_SET);
        this.trust = context.getConfiguration().get("propagatetocommunity.trust", "0.85");
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes()).getType();
        if (!type.equals((Object)TypeProtos.Type.result)) {
            return;
        }
        OafProtos.OafEntity entity = Utils.getEntity(value, type);
        if (entity == null) {
            context.getCounter("Propagation", "Del by inference or null body for result").increment(1L);
            return;
        }
        HashSet<String> toemitrelations = new HashSet<String>();
        for (String sem_rel : this.sem_rels) {
            toemitrelations.addAll(Utils.getRelationTarget(value, sem_rel, context, "Propagation"));
        }
        if (toemitrelations.isEmpty()) {
            context.getCounter("Propagation", "No allowed semantic relation present in result").increment(1L);
            return;
        }
        Set contextIds = entity.getResult().getMetadata().getContextList().stream().map(ResultProtos.Result.Context::getId).collect(Collectors.toSet());
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)TypeProtos.Type.result.toString()));
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry e : map.entrySet()) {
            stringMap.put(Bytes.toString((byte[])((byte[])e.getKey())), e.getValue());
        }
        for (String o : stringMap.keySet()) {
            if (!o.startsWith("update_")) continue;
            OafProtos.Oaf update = OafProtos.Oaf.parseFrom((byte[])((byte[])stringMap.get(o)));
            contextIds.addAll(update.getEntity().getResult().getMetadata().getContextList().stream().map(ResultProtos.Result.Context::getId).map(s -> s.split("::")[0]).collect(Collectors.toSet()));
        }
        if (contextIds.isEmpty()) {
            context.getCounter("Propagation", "No context in the body and in the update of the result").increment(1L);
            return;
        }
        for (String id : this.idCommunityList) {
            if (!contextIds.contains(id)) continue;
            for (String target : toemitrelations) {
                this.keyOut.set(target);
                this.valueOut.set(Value.newInstance(id).setTrust(this.trust).toJson());
                context.write((Object)this.keyOut, (Object)this.valueOut);
                context.getCounter("Propagation", "Emit propagation for " + id).increment(1L);
            }
        }
    }
}

