/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts;

import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts.ResultOrcidIterator;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationOrcidToResultReducer
extends TableReducer<ImmutableBytesWritable, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationOrcidToResultReducer.class);
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ResultOrcidIterator rh = null;
        try {
            rh = new ResultOrcidIterator(values, Bytes.toString((byte[])key.copyBytes()));
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        while (rh.hasNext()) {
            Object oaf_list = ((ResultIterator)rh).next();
            if (oaf_list == null) continue;
            Iterator iterator = oaf_list.iterator();
            while (iterator.hasNext()) {
                OafProtos.Oaf oaf = (OafProtos.Oaf)iterator.next();
                byte[] targetRowKey = Bytes.toBytes((String)oaf.getEntity().getId());
                Put put = new Put(targetRowKey).add(Bytes.toBytes((String)"result"), Bytes.toBytes((String)("update_" + System.nanoTime())), oaf.toByteArray());
                this.keyOut.set(targetRowKey);
                context.write((Object)this.keyOut, (Object)put);
                context.getCounter("Propagation", "added orcid to product").increment(1L);
            }
        }
    }
}

