/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.datasource;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.Emit;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PropagationProductToOrganizationMapper
extends TableMapper<InstOrgKey, Text> {
    private Set<String> datasourceTypes = Sets.newHashSet((Object[])new String[]{"pubsrepository::institutional"});
    private Set<String> whiteList = Sets.newHashSet((Object[])new String[]{"10|opendoar____::300891a62162b960cf02ce3827bb363c"});
    private Text valueOut;
    private String[] sem_rels;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.valueOut = new Text();
        this.datasourceTypes.addAll(this.getParam(context, "datasource.types"));
        this.whiteList.addAll(this.getParam(context, "datasource.whitelist"));
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes()).getType();
        OafProtos.OafEntity entity = Utils.getEntity(value, type);
        if (entity != null) {
            String id = entity.getId();
            switch (type) {
                case datasource: {
                    DatasourceProtos.Datasource datasource = entity.getDatasource();
                    if (datasource == null) {
                        throw new RuntimeException("oaf type is datasource, but datasource proto is not found in oafproto");
                    }
                    String dsType = datasource.getMetadata().getDatasourcetype().getClassid();
                    if (this.datasourceTypes.contains(dsType) || this.whiteList.contains(id)) {
                        this.valueOut.set(Value.newInstance("1", "0.85", PropagationConstants.Type.valid).toJson());
                        context.getCounter("Propagation", String.format("%s in propagation allowed list or id whitelisted", dsType)).increment(1L);
                    } else {
                        this.valueOut.set(Value.newInstance("0", "0.85", PropagationConstants.Type.notvalid).toJson());
                        context.getCounter("Propagation", String.format("%s in propagation not allowed list", dsType)).increment(1L);
                    }
                    context.write((Object)InstOrgKey.datasource(id), (Object)this.valueOut);
                    break;
                }
                case organization: {
                    OrganizationProtos.Organization organization = entity.getOrganization();
                    if (organization == null) {
                        throw new RuntimeException("oaf type is organizationtoresult, but organizationtoresult proto is not found in oafproto");
                    }
                    NavigableMap ds_org = value.getFamilyMap((PropagationConstants.DATASOURCE_RELATION_ORGANIZATION + "isProvidedBy").getBytes());
                    if (!MapUtils.isNotEmpty((Map)ds_org)) break;
                    for (String dsId : ds_org.keySet().stream().map(String::new).collect(Collectors.toList())) {
                        this.valueOut.set(Value.newInstance(id, "0.85", PropagationConstants.Type.fromorganization).toJson());
                        context.write((Object)InstOrgKey.organization(dsId), (Object)this.valueOut);
                        context.getCounter("Propagation", "emit for organization ").increment(1L);
                    }
                    break;
                }
                case result: {
                    ResultProtos.Result result = entity.getResult();
                    Set<String> institution = Utils.getRelationTarget(value, PropagationConstants.RELATION_ORGANIZATION + "hasAuthorInstitution", context, "Propagation");
                    Emit e = new Emit();
                    e.setId(id);
                    e.setResult_list(institution.stream().collect(Collectors.toList()));
                    this.valueOut.set(Value.newInstance(new Gson().toJson((Object)e, Emit.class), "0.85", PropagationConstants.Type.fromresult).toJson());
                    for (ResultProtos.Result.Instance instance : result.getInstanceList()) {
                        String hostedBy = instance.getHostedby().getKey();
                        context.write((Object)InstOrgKey.publication(hostedBy), (Object)this.valueOut);
                        context.getCounter("Propagation", "emit hostedby | collectedfrom for result ").increment(1L);
                        String collectedFrom = instance.getCollectedfrom().getKey();
                        if (hostedBy.equals(collectedFrom)) continue;
                        context.write((Object)InstOrgKey.publication(collectedFrom), (Object)this.valueOut);
                        context.getCounter("Propagation", "emit hostedby | collectedfrom for result ").increment(1L);
                    }
                    break;
                }
            }
        }
    }

    private ArrayList<String> getParam(Mapper.Context context, String s) {
        return Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)context.getConfiguration().get(s, "")));
    }
}

