/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class CountXmlRecordsMapper
extends Mapper<Text, Text, NullWritable, NullWritable> {
    private static final Log log = LogFactory.getLog(CountXmlRecordsMapper.class);
    private SAXReader saxReader;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.saxReader = new SAXReader();
    }

    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            Document doc = this.saxReader.read((Reader)new StringReader(value.toString()));
            Boolean deleted = Boolean.valueOf(doc.valueOf("//*[local-name()='entity']//datainfo/deletedbyinference"));
            String oaftype = doc.valueOf("local-name(//*[local-name()='entity']/*)");
            context.getCounter(oaftype, String.format("%s deleted %s", oaftype, deleted)).increment(1L);
            if (TypeProtos.Type.result.toString().equals(oaftype)) {
                String resulttypeid = doc.valueOf("//*[local-name()='entity']/*[local-name()='result']/resulttype/@classid");
                context.getCounter(oaftype, String.format("%s deleted %s", resulttypeid, deleted)).increment(1L);
            }
        }
        catch (Throwable e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
        }
    }
}

