/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.communitythroughorganization;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.communitythroughorganization.DedupedList;
import eu.dnetlib.data.mapreduce.hbase.propagation.communitythroughorganization.OrganizationMap;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PropagationCommunityThroughOrganizationMapper
extends TableMapper<ImmutableBytesWritable, Text> {
    private Text valueOut;
    private ImmutableBytesWritable keyOut;
    private OrganizationMap organizationMap;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.valueOut = new Text();
        this.keyOut = new ImmutableBytesWritable();
        this.organizationMap = (OrganizationMap)new Gson().fromJson(context.getConfiguration().get("organizationtoresult.community.map"), OrganizationMap.class);
        System.out.println("got organizationtoresult map: " + new Gson().toJson((Object)this.organizationMap));
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes()).getType();
        OafProtos.OafEntity entity = Utils.getEntity(value, type);
        if (entity != null) {
            switch (type) {
                case organization: {
                    DedupedList communityList = this.getCommunityList(Bytes.toString((byte[])keyIn.get()), Utils.getRelationTarget(value, PropagationConstants.DEDUP_RELATION_ORGANIZATION + "merges", context, "Propagation"), context);
                    if (communityList.size() > 0) {
                        this.valueOut.set(Value.newInstance(new Gson().toJson((Object)communityList, DedupedList.class), "0.85", PropagationConstants.Type.fromorganization).toJson());
                        context.write((Object)keyIn, (Object)this.valueOut);
                        context.getCounter("Propagation", "emit for organizationtoresult ").increment(1L);
                        break;
                    }
                    context.getCounter("Propagation", "community list size = 0 ").increment(1L);
                    break;
                }
                case result: {
                    Set<String> result_organization = Utils.getRelationTarget(value, PropagationConstants.RELATION_ORGANIZATION + "hasAuthorInstitution", context, "Propagation");
                    for (String org : result_organization) {
                        this.emit(org, Bytes.toString((byte[])keyIn.get()), context);
                    }
                    break;
                }
            }
        }
    }

    private DedupedList getCommunityList(String organizationId, Set<String> relationTarget, Mapper.Context context) {
        DedupedList communityList = new DedupedList();
        relationTarget.stream().forEach(org -> communityList.addAll(this.organizationMap.get(StringUtils.substringAfter((String)org, (String)"|"))));
        communityList.addAll(this.organizationMap.get(StringUtils.substringAfter((String)organizationId, (String)"|")));
        communityList.stream().forEach(c -> context.getCounter("Propagation", "found organizationtoresult for " + c).increment(1L));
        return communityList;
    }

    private void emit(String org, String resId, Mapper.Context context) throws IOException, InterruptedException {
        this.keyOut.set(Bytes.toBytes((String)org));
        this.valueOut.set(Value.newInstance(resId, "0.85", PropagationConstants.Type.fromresult).toJson());
        context.write((Object)this.keyOut, (Object)this.valueOut);
        context.getCounter("Propagation", "emit for result").increment(1L);
    }
}

