/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.communitythroughorganization;

import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.communitythroughorganization.DedupedList;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationCommunityThroughOrganizationReducer
extends TableReducer<ImmutableBytesWritable, Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PropagationCommunityThroughOrganizationReducer.class);
    private ImmutableBytesWritable keyOut;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterator<Text> it = values.iterator();
        DedupedList communities = new DedupedList();
        HashSet<String> resultIds = new HashSet<String>();
        while (it.hasNext()) {
            Value v = Value.fromJson(it.next().toString());
            switch (v.getType()) {
                case fromorganization: {
                    communities.addAll(DedupedList.fromJson(v.getValue()));
                    break;
                }
                case fromresult: {
                    resultIds.add(v.getValue());
                }
            }
        }
        if (communities.size() > 0) {
            ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
            communities.stream().forEach(community -> {
                metadata.addContext(Utils.getContext(community, "0.85", "propagation:community:organizationtoresult", "propagation", "Propagation of community result through organization to result association"));
                context.getCounter("Propagation", "added result to community " + community).increment((long)resultIds.size());
            });
            for (String result : resultIds) {
                Put put = new Put(Bytes.toBytes((String)result)).add(Bytes.toBytes((String)"result"), Bytes.toBytes((String)("update_" + System.nanoTime())), Utils.getUpdate(metadata, result).toByteArray());
                this.keyOut.set(Bytes.toBytes((String)result));
                context.write((Object)this.keyOut, (Object)put);
                context.getCounter("Propagation", "added community to result").increment((long)communities.size());
            }
        }
    }
}

