package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.data.mapreduce.hbase.broker.OrcidEventFactory;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.FieldTypeProtos.StringField;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result.Instance;

import static eu.dnetlib.data.mapreduce.util.OafHbaseUtils.*;

/**
 * Created by alessia on 21/07/16.
 */
public class HighlightFactory extends ProtoMapping {

	public static OpenAireEventPayload highlightEnrichOa(final OpenAireEventPayload p, final Collection<Instance> instances) {
		p.getHighlight().setInstances(mapInstances(instances));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichPid(final OpenAireEventPayload p, final List<StructuredProperty> pids) {
		p.getHighlight().setPids(mapPids(pids));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichPublicationDate(final OpenAireEventPayload p, final StringField date) {
		p.getHighlight().setPublicationdate(getValue(date));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichAbstract(final OpenAireEventPayload p, final List<StringField> descriptionList) {
		p.getHighlight().setAbstracts(listValues(descriptionList));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichOrcidAuthor(final OpenAireEventPayload p, final FieldTypeProtos.Author author) {
		final FieldTypeProtos.Author.Builder authorBuilder = FieldTypeProtos.Author.newBuilder(author);
		List<FieldTypeProtos.KeyValue> orcid = authorBuilder.getPidBuilderList().stream()
				.filter(pid -> OrcidEventFactory.ORCID_TYPE_MARKER.equals(pid.getKey()))
				.map(pid -> pid.build())
				.collect(Collectors.toList());
		authorBuilder.clearPid().addAllPid(orcid);

		p.getHighlight().getCreators().add(mapValue(authorBuilder.build()));
		return p;
	}

	public static OpenAireEventPayload highlightEnrichSubject(final OpenAireEventPayload p, final List<StructuredProperty> subjects) {
		p.getHighlight().setSubjects(listValues(subjects));
		return p;
	}

	// TODO: highlight for the following reasons
	public static OpenAireEventPayload highlightEnrichProject(final OpenAireEventPayload p, final OafEntity project, final String provenance) {
		// TODO: this can wait. Think about generating the openaire string for project links: it will be easier for subscribers to integrate
		// it back to their records!

		p.getHighlight().setProjects(Lists.newArrayList(mapRelatedProject(project.getProject())));

		return p;
	}

	public static OpenAireEventPayload highlightEnrichSoftware(final OpenAireEventPayload p, final OafEntity software, final String provenance) {

		p.getHighlight().setSoftwares(Lists.newArrayList(mapRelatedSoftware(software.getResult())));

		return p;
	}

	public static OpenAireEventPayload highlightEnrichDataset(final OpenAireEventPayload p) {
		// TODO: this can wait
		return p;
	}

	public static OpenAireEventPayload highlightEnrichAuthorPid(final OpenAireEventPayload p) {
		// TODO: this can wait
		return p;
	}

	// Commenting highlights for addition events: the record is new for the subscriber!
	/*
	 * public static OpenAireEventPayload highlightAddByAffiliation(final OpenAireEventPayload p){ return p; }
	 *
	 * public static OpenAireEventPayload highlightAddByReference(final OpenAireEventPayload p){ return p; }
	 *
	 * public static OpenAireEventPayload highlightAddByProject(final OpenAireEventPayload p){ //TODO: this cannot wait return p; }
	 */

}
