package eu.dnetlib.data.mapreduce.hbase.propagation.communitytoresult;

import com.googlecode.protobuf.format.JsonFormat;

import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;

import eu.dnetlib.data.proto.ResultProtos;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;
import java.util.Iterator;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.*;


public class CommunityToResultFileReducer extends Reducer<ImmutableBytesWritable, Text, Text, Text> {

    private static final Log log = LogFactory.getLog(CommunityToResultFileReducer.class); // NOPMD by marko on 11/24/08 5:02 PM

    private Text keyOut;
    private Text outValue;


    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new Text("");
        outValue = new Text();
    }


    @Override
    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
        Iterator<Text> it = values.iterator();
        final ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        while(it.hasNext()){
            Value v = Value.fromJson(it.next().toString());
            metadata.addContext(Utils.getContext(v.getValue(),v.getTrust(), CLASS_COMMUNITY_ID, DATA_INFO_TYPE, CLASS_COMMUNITY_NAME));

        }
        String keyString = Bytes.toString(key.get());
        keyOut.set(keyString);

        outValue.set(JsonFormat.printToString(Utils.getUpdate(metadata, keyString)).getBytes());
        context.write(keyOut, outValue);


    }


}
