/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.broker.objects.Software;
import eu.dnetlib.data.mapreduce.hbase.broker.Topic;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.EventFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.OpenAireEventPayloadFactory;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.ProtoMapping;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventMessage;
import eu.dnetlib.data.mapreduce.hbase.broker.model.EventWrapper;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.mapreduce.Reducer;
import org.dom4j.DocumentException;

public class SoftwareEventFactory
extends ProtoMapping {
    private final Set<String> inferenceProvenance = Sets.newHashSet((Object[])new String[]{"sysimport:mining:repository", "iis"});
    private Map<String, String> baseUrlMap;

    public SoftwareEventFactory(Map<String, String> baseUrlMap) {
        this.baseUrlMap = baseUrlMap;
    }

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust, Map<String, String> baseUrlMap) throws IOException, InterruptedException, DocumentException {
        return new SoftwareEventFactory(baseUrlMap).processSoftware(context, current, other, trust);
    }

    public static List<EventWrapper> process(Reducer.Context context, OafProtos.Oaf current, Map<String, String> baseUrlMap) throws IOException, InterruptedException, DocumentException {
        return SoftwareEventFactory.process(context, current, null, null, baseUrlMap);
    }

    private List<EventWrapper> processSoftware(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Float trust) throws IOException, InterruptedException, DocumentException {
        ArrayList events = Lists.newArrayList();
        if (other == null) {
            for (OafProtos.Oaf oafRel : current.getEntity().getCachedOafRelList()) {
                String provenance = oafRel.getDataInfo().getProvenanceaction().getClassid();
                if (!this.inferenceProvenance.contains(provenance)) continue;
                Software software = SoftwareEventFactory.mapRelatedSoftware(oafRel.getRel().getCachedOafTarget().getEntity().getResult());
                events.add(this.doProcessSoftware(context, current, current, software, provenance, Topic.ENRICH_MISSING_SOFTWARE, this.trust(trust, oafRel)));
            }
        } else {
            for (OafProtos.Oaf currentOafRel : current.getEntity().getCachedOafRelList()) {
                for (OafProtos.Oaf otherOafRel : other.getEntity().getCachedOafRelList()) {
                    String otherTarget;
                    String currentTarget = currentOafRel.getRel().getTarget();
                    if (currentTarget.equals(otherTarget = otherOafRel.getRel().getTarget())) continue;
                    String provenance = otherOafRel.getDataInfo().getProvenanceaction().getClassid();
                    OafProtos.OafEntity swEntity = otherOafRel.getRel().getCachedOafTarget().getEntity();
                    Software software = SoftwareEventFactory.mapRelatedSoftware(swEntity.getResult());
                    boolean currentHasSw = Iterables.tryFind((Iterable)current.getEntity().getCachedOafRelList(), oaf -> {
                        String currentSwId = oaf.getRel().getCachedOafTarget().getEntity().getId();
                        return currentSwId.equals(swEntity.getId());
                    }).isPresent();
                    if (currentHasSw) continue;
                    events.add(this.doProcessSoftware(context, current, other, software, provenance, Topic.ENRICH_MISSING_SOFTWARE, this.trust(trust, currentOafRel)));
                }
            }
        }
        return events;
    }

    private EventWrapper doProcessSoftware(Reducer.Context context, OafProtos.Oaf current, OafProtos.Oaf other, Software software, String provenance, Topic topic, Float trust) throws IOException, InterruptedException, DocumentException {
        OafProtos.OafEntity currentEntity = current.getEntity();
        OafProtos.OafEntity otherEntity = other.getEntity();
        Provenance prov = this.getProvenance(otherEntity, provenance);
        OpenAireEventPayload payload = OpenAireEventPayloadFactory.fromOAF(currentEntity, trust.floatValue(), prov);
        HashMap swMap = Maps.newHashMap();
        for (Software s2 : payload.getPublication().getSoftwares()) {
            swMap.put(s2.getLandingPage(), s2);
        }
        swMap.put(software.getLandingPage(), software);
        payload.getPublication().setSoftwares((List)Lists.newArrayList(swMap.values()));
        payload.getHighlight().setSoftwares((List)Lists.newArrayList((Object[])new Software[]{software}));
        EventMessage event = EventFactory.asEvent(currentEntity, topic, payload, otherEntity, trust.floatValue());
        event.setPayload(payload.toJSON());
        return EventWrapper.newInstance(event, payload.getHighlight().getSoftwares().stream().filter(Objects::nonNull).map(s -> s.getName()).sorted().collect(Collectors.joining(", ")), topic.getValue());
    }

    private Provenance getProvenance(OafProtos.OafEntity entity, String provenance) {
        if (this.inferenceProvenance.contains(provenance)) {
            return new Provenance().setRepositoryName("OpenAIRE").setUrl(this.getUrl(entity)).setId((String)Iterables.getFirst((Iterable)entity.getOriginalIdList(), (Object)""));
        }
        return new Provenance().setRepositoryName(OafHbaseUtils.getValue(entity.getCollectedfromList())).setUrl(((Instance)Iterables.getFirst(SoftwareEventFactory.mapInstances(entity.getResult().getInstanceList()), (Object)new Instance())).getUrl()).setId(OafHbaseUtils.getValue(entity.getOriginalIdList()));
    }

    private String getUrl(OafProtos.OafEntity entity) {
        if (entity.getType().equals((Object)TypeProtos.Type.result)) {
            String resulttype = entity.getResult().getMetadata().getResulttype().getClassid();
            return String.format(this.baseUrlMap.get(resulttype), StringUtils.substringAfter((String)entity.getId(), (String)"|"));
        }
        return "";
    }

    private Float trust(Float trust, OafProtos.Oaf oaf) {
        Float provenanceTrust = Float.valueOf(oaf.getDataInfo().getTrust());
        return Float.valueOf(trust != null ? trust.floatValue() * provenanceTrust.floatValue() : provenanceTrust.floatValue());
    }
}

