/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.openorgs;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.openorgs.Similarity;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class GenerateSimilaritiesReducer
extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, Text> {
    private final Text valueOut = new Text();

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            ArrayList<OafProtos.OafEntity> list = new ArrayList<OafProtos.OafEntity>();
            for (ImmutableBytesWritable ibw : values) {
                list.add(OafProtos.Oaf.parseFrom((byte[])ibw.get()).getEntity());
            }
            if (list.size() < 2) {
                return;
            }
            List<String> mainIds = this.findMainIds("openorgs____::", list);
            if (mainIds.size() > 10) {
                context.getCounter("organization", "groups with n of openOrgsID > 10").increment(1L);
            } else {
                context.getCounter("organization", "groups with n of openOrgsID = " + mainIds.size()).increment(1L);
            }
            for (String mainId : mainIds) {
                if (!StringUtils.isNotBlank((CharSequence)mainId)) continue;
                for (OafProtos.OafEntity o : list) {
                    if (o.getOriginalIdList().contains(mainId)) continue;
                    context.getCounter("organization", "relations to openorgs____::*").increment(1L);
                    this.emit(this.newSimilarity(mainId, o), context);
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<String> findMainIds(String idPrefix, List<OafProtos.OafEntity> list) {
        ArrayList<String> valids = new ArrayList<String>();
        for (OafProtos.OafEntity e : list) {
            for (String id : e.getOriginalIdList()) {
                if (!id.startsWith(idPrefix)) continue;
                valids.add(id);
            }
        }
        return valids;
    }

    private void emit(Similarity simrel, Reducer.Context context) {
        try {
            this.valueOut.set(simrel.toTsv());
            context.getCounter("organization", "relations (total)").increment(1L);
            context.write((Object)NullWritable.get(), (Object)this.valueOut);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Similarity newSimilarity(String openOrgsId, OafProtos.OafEntity oafEntity) {
        Similarity s = new Similarity();
        s.setOpenOrgID(openOrgsId);
        s.setOpenaireOriginalId(oafEntity.getOriginalId(0));
        s.setName(oafEntity.getOrganization().getMetadata().getLegalname().getValue());
        s.setAcronym(oafEntity.getOrganization().getMetadata().getLegalshortname().getValue());
        s.setCountry(oafEntity.getOrganization().getMetadata().getCountry().getClassid());
        s.setUrl(oafEntity.getOrganization().getMetadata().getWebsiteurl().getValue());
        s.setCollectedFrom(oafEntity.getCollectedfrom(0).getValue());
        return s;
    }
}

