/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts.ResultOrcidIterator;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class PropagationOrcidToResultFileReducer
extends Reducer<ImmutableBytesWritable, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(PropagationOrcidToResultFileReducer.class);
    private Text keyOut;
    private Text outValue;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.outValue = new Text();
    }

    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        ResultOrcidIterator rh = null;
        try {
            rh = new ResultOrcidIterator(values, Bytes.toString((byte[])key.copyBytes()));
        }
        catch (NotValidResultSequenceException e) {
            context.getCounter("Propagation", e.getMessage()).increment(1L);
            return;
        }
        while (rh.hasNext()) {
            Object oaf_list = ((ResultIterator)rh).next();
            if (oaf_list == null) continue;
            Iterator iterator = oaf_list.iterator();
            while (iterator.hasNext()) {
                OafProtos.Oaf oaf = (OafProtos.Oaf)iterator.next();
                this.keyOut.set(oaf.getEntity().getId());
                this.outValue.set(JsonFormat.printToString((Message)oaf).getBytes());
                context.write((Object)this.keyOut, (Object)this.outValue);
                context.getCounter("Propagation", "Added orcid to result").increment(1L);
            }
        }
    }
}

