/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware;

import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.Constants;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.Identifier;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.IdentifierList;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.SoftwareResource;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.Value;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PubSfwLinkMapper
extends TableMapper<ImmutableBytesWritable, Text> {
    public static final String COUNTER_GROUP = "Find Link Pub Software";
    private ImmutableBytesWritable keyOut;
    private Text valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new ImmutableBytesWritable();
        this.valueOut = new Text();
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap resultMap = value.getFamilyMap(Bytes.toBytes((String)"result"));
        byte[] body = (byte[])resultMap.get(Bytes.toBytes((String)"body"));
        if (body != null) {
            context.getCounter(COUNTER_GROUP, "not null body ").increment(1L);
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])body);
            if (oaf == null) {
                return;
            }
            if (oaf.getDataInfo().getDeletedbyinference()) {
                context.getCounter(COUNTER_GROUP, "deleted by inference").increment(1L);
                return;
            }
            String resulttype = oaf.getEntity().getResult().getMetadata().getResulttype().getClassid();
            NavigableMap relationMap = value.getFamilyMap(Bytes.toBytes((String)"resultResult_relationship_isRelatedTo"));
            if (relationMap == null || relationMap.isEmpty()) {
                context.getCounter(COUNTER_GROUP, String.format("missing relation (%s)", resulttype)).increment(1L);
                return;
            }
            IdentifierList pids = oaf.getEntity().getPidList().stream().map(pid -> new Identifier(pid.getQualifier().getClassid(), pid.getValue())).collect(Collectors.toCollection(IdentifierList::new));
            context.getCounter(COUNTER_GROUP, resulttype).increment(1L);
            switch (resulttype) {
                case "publication": {
                    this.emit(oaf.getEntity().getId(), Value.newInstance(pids.toJson(), Constants.Type.publication).toJson(), context);
                    break;
                }
                case "software": {
                    List targets = relationMap.values().stream().map(this::asOaf).filter(Objects::nonNull).filter(o -> this.isValid((OafProtos.Oaf)o)).filter(o -> !o.getDataInfo().getDeletedbyinference()).map(o -> o.getRel().getTarget()).collect(Collectors.toList());
                    Set urls = oaf.getEntity().getResult().getInstanceList().stream().map(i -> i.getUrlList()).flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
                    SoftwareResource sr = new SoftwareResource().setOpenAireId(new String(key.copyBytes())).setUrls(Lists.newArrayList((Iterable)urls)).setSoftwarePIDs(pids);
                    for (String target : targets) {
                        this.emit(target, Value.newInstance(sr.toJson(), Constants.Type.software).toJson(), context);
                    }
                    break;
                }
            }
        }
    }

    private void emit(String target, String value, Mapper.Context context) throws IOException, InterruptedException {
        this.keyOut.set(target.getBytes());
        this.valueOut.set(value);
        context.write((Object)this.keyOut, (Object)this.valueOut);
    }

    private OafProtos.Oaf asOaf(byte[] r) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])r);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    private boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }
}

