/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.openorgs;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.OafProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class GenerateOrganizationsReducer
extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, Text> {
    private final Text valueOut = new Text();

    protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            ArrayList<OafProtos.OafEntity> list = new ArrayList<OafProtos.OafEntity>();
            for (ImmutableBytesWritable ibw : values) {
                list.add(OafProtos.Oaf.parseFrom((byte[])ibw.get()).getEntity());
            }
            OafProtos.OafEntity e1 = this.findOrgToEmit("openorgs____::", list);
            if (e1 != null) {
                context.getCounter("organization", "already present in openOrgs").increment(1L);
                return;
            }
            OafProtos.OafEntity e2 = this.findOrgToEmit("corda_______::", list);
            if (e2 != null) {
                context.getCounter("organization", "new (from corda FP7)").increment(1L);
                this.emit(e2, context);
                return;
            }
            OafProtos.OafEntity e3 = this.findOrgToEmit("corda__h2020::", list);
            if (e3 != null) {
                context.getCounter("organization", "new (from corda H2020)").increment(1L);
                this.emit(e3, context);
                return;
            }
            OafProtos.OafEntity e4 = this.findOrgToEmit("", list);
            if (e4 != null) {
                context.getCounter("organization", "new (from other sources)").increment(1L);
                this.emit(e4, context);
                return;
            }
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private OafProtos.OafEntity findOrgToEmit(String idPrefix, List<OafProtos.OafEntity> list) {
        ArrayList<OafProtos.OafEntity> valids = new ArrayList<OafProtos.OafEntity>();
        for (OafProtos.OafEntity e : list) {
            if (!e.getId().startsWith("20|" + idPrefix)) continue;
            valids.add(e);
        }
        if (valids.isEmpty()) {
            return null;
        }
        valids.sort((o1, o2) -> StringUtils.compare((String)o1.getId(), (String)o2.getId()));
        return (OafProtos.OafEntity)valids.get(0);
    }

    private void emit(OafProtos.OafEntity entity, Reducer.Context context) {
        try {
            context.getCounter("organization", "new (total)").increment(1L);
            this.valueOut.set(JsonFormat.printToString((Message)entity));
            context.write((Object)NullWritable.get(), (Object)this.valueOut);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

