package eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult.PropagationProjectToResultReducer;
import eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult.ResultProjectIterator;
import eu.dnetlib.data.proto.OafProtos;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;
import java.util.List;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.COUNTER_PROPAGATION;

public class PropagationOrcidToResultFileReducer extends Reducer<ImmutableBytesWritable, Text, Text, Text> {
    private static final Log log = LogFactory.getLog(PropagationOrcidToResultFileReducer.class); // NOPMD by marko on 11/24/08 5:02 PM

    private Text keyOut;
    private Text outValue;


    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new Text("");
        outValue = new Text();
    }


    @Override
    protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
        ResultIterator rh = null;
        try {
            rh = new ResultOrcidIterator(values, Bytes.toString(key.copyBytes()));
        } catch (NotValidResultSequenceException e) {
            context.getCounter(COUNTER_PROPAGATION, e.getMessage()).increment(1);
            return;
        }
        while (rh.hasNext()) {
            List<OafProtos.Oaf> oaf_list = rh.next();
            if(oaf_list != null){
                for (OafProtos.Oaf oaf : oaf_list) {
                    keyOut.set(oaf.getEntity().getId());
                    outValue.set(JsonFormat.printToString(oaf).getBytes());
                    context.write(keyOut, outValue);
                    context.getCounter(COUNTER_PROPAGATION, "Added orcid to result").increment(1);
                }

            }

        }

    }
}
