/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.mapping;

import com.google.common.collect.Iterables;
import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.broker.objects.OpenAireEventPayload;
import eu.dnetlib.broker.objects.Provenance;
import eu.dnetlib.broker.objects.Publication;
import eu.dnetlib.data.mapreduce.hbase.broker.mapping.ProtoMapping;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;

public class OpenAireEventPayloadFactory
extends ProtoMapping {
    public static OpenAireEventPayload fromOAF(OafProtos.OafEntity oaf, OafProtos.OafEntity source, float trust) {
        return OpenAireEventPayloadFactory.fromOAF(oaf, trust, new Provenance().setRepositoryName(OafHbaseUtils.getValue(source.getCollectedfromList())).setUrl(((Instance)Iterables.getFirst(OpenAireEventPayloadFactory.mapInstances(oaf.getResult().getInstanceList()), (Object)new Instance())).getUrl()).setId(OafHbaseUtils.getValue(source.getOriginalIdList())));
    }

    public static OpenAireEventPayload fromOAF(OafProtos.OafEntity oaf, float trust, Provenance provenance) {
        ResultProtos.Result.Metadata m = oaf.getResult().getMetadata();
        Publication p = new Publication().setOriginalId(OafHbaseUtils.getValue(oaf.getOriginalIdList())).setTitles(OafHbaseUtils.listValues(m.getTitleList())).setAbstracts(OafHbaseUtils.listValues(m.getDescriptionList())).setLanguage(OafHbaseUtils.getKey(m.getLanguage())).setSubjects(OafHbaseUtils.listValues(m.getSubjectList())).setCreators(OafHbaseUtils.listValues(oaf.getResult().getMetadata().getAuthorList())).setPublicationdate(OafHbaseUtils.getValue(m.getDateofacceptance())).setPublisher(OafHbaseUtils.getValue(m.getPublisher())).setEmbargoenddate(OafHbaseUtils.getValue(m.getEmbargoenddate())).setContributor(OafHbaseUtils.listValues(m.getContributorList())).setJournal(OpenAireEventPayloadFactory.mapJournal(m.getJournal())).setCollectedFrom(OafHbaseUtils.listValues(oaf.getCollectedfromList())).setPids(OpenAireEventPayloadFactory.mapPids(oaf.getPidList())).setInstances(OpenAireEventPayloadFactory.mapInstances(oaf.getResult().getInstanceList())).setExternalReferences(OpenAireEventPayloadFactory.mapExternalRefs(oaf.getResult().getExternalReferenceList())).setProjects(OpenAireEventPayloadFactory.mapRelatedProjects(oaf));
        return new OpenAireEventPayload().setPublication(p).setHighlight(new Publication()).setProvenance(provenance).setTrust(trust);
    }
}

