/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataexport;

import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import java.text.ParseException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.tree.DefaultText;

public class RecordFilter {
    private Map<String, String> criteria;
    private String yearXpath;
    private int fromYear;
    private int toYear;

    public RecordFilter(Map<String, String> criteria, String yearXpath, int fromYear, int toYear) {
        this.criteria = criteria;
        this.yearXpath = yearXpath;
        this.fromYear = fromYear;
        this.toYear = toYear;
    }

    public boolean matches(Document record, boolean strict) throws ParseException {
        String date = record.valueOf(this.yearXpath);
        if (StringUtils.isBlank((CharSequence)date)) {
            return false;
        }
        String yyyy = DnetXsltFunctions.extractYear((String)date);
        if (StringUtils.isBlank((CharSequence)yyyy)) {
            return false;
        }
        Integer year = Integer.valueOf(yyyy);
        if (year < this.fromYear | year > this.toYear) {
            return false;
        }
        boolean matched = false;
        for (Map.Entry<String, String> c : this.criteria.entrySet()) {
            matched = record.selectNodes(c.getKey()).stream().filter(Objects::nonNull).map(o -> this.textOf(o)).map(s -> ((String)s).toLowerCase()).map(s -> ((String)s).trim()).anyMatch(s -> ((String)s).matches(((String)c.getValue()).toLowerCase()));
            boolean matches = matched;
            if (!matches || strict) continue;
            return true;
        }
        return matched;
    }

    private String textOf(Object o) {
        if (o instanceof DefaultText) {
            return ((DefaultText)o).getText();
        }
        return o.toString();
    }
}

