package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.HashMap;
import java.util.List;

import eu.dnetlib.data.mapreduce.util.RelDescriptor;

public class EntityConfig {

	private Boolean includeDuplicates;

	private HashMap<RelDescriptor, LinkDescriptor> links;

	private List<String> includeFields;

	private List<String> excludeFields;

	public EntityConfig(final Boolean includeDuplicates, final HashMap<RelDescriptor, LinkDescriptor> links) {
		super();
		this.includeDuplicates = includeDuplicates;
		this.links = links;
	}

	public EntityConfig(final Boolean includeDuplicates,
			final HashMap<RelDescriptor, LinkDescriptor> links,
			final List<String> includeFields,
			final List<String> excludeFields) {
		super();
		this.includeDuplicates = includeDuplicates;
		this.links = links;
		this.includeFields = includeFields;
		this.excludeFields = excludeFields;
	}

	public Boolean getIndexDuplicates() {
		return includeDuplicates;
	}

	public void setIndexDuplicates(final Boolean indexDuplicates) {
		this.includeDuplicates = indexDuplicates;
	}

	public HashMap<RelDescriptor, LinkDescriptor> getLinks() {
		return links;
	}

	public void setLinks(final HashMap<RelDescriptor, LinkDescriptor> links) {
		this.links = links;
	}

	public List<String> getIncludeFields() {
		return includeFields;
	}

	public void setIncludeFields(final List<String> includeFields) {
		this.includeFields = includeFields;
	}

	public List<String> getExcludeFields() {
		return excludeFields;
	}

	public void setExcludeFields(final List<String> excludeFields) {
		this.excludeFields = excludeFields;
	}
}
