/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts.Emit;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.io.Text;

public class ResultOrcidIterator
extends ResultIterator {
    private Iterator<String> author_iterator;
    private List<FieldTypeProtos.Author> autoritative_authors;
    private List<String> relatedResult;

    public ResultOrcidIterator(Iterable<Text> values, String key) throws NotValidResultSequenceException {
        super(values, key);
    }

    @Override
    protected void checkSequence() throws NotValidResultSequenceException {
        if (!this.it.hasNext()) {
            throw new NotValidResultSequenceException("Empty information for key");
        }
        try {
            this.autoritative_authors = new ArrayList<FieldTypeProtos.Author>();
            this.relatedResult = new ArrayList<String>();
            this.analizeValueList();
        }
        catch (JsonFormat.ParseException e) {
            throw new NotValidResultSequenceException("Problems recreating the author list from serialization");
        }
        List authors_with_orcid = this.autoritative_authors.stream().map(a -> {
            if (a.getPidList() == null || a.getPidList().isEmpty()) {
                return null;
            }
            return a;
        }).filter(a -> a != null).filter(a -> this.containsOrcid(a.getPidList())).collect(Collectors.toList());
        if (authors_with_orcid.size() == 0 || this.relatedResult.size() == 0) {
            this.resultId = "FINITO";
            return;
        }
        this.author_iterator = this.relatedResult.iterator();
        this.autoritative_authors = authors_with_orcid;
        this.getNext();
    }

    private boolean containsOrcid(List<FieldTypeProtos.KeyValue> pidList) {
        if (pidList == null) {
            return false;
        }
        return pidList.stream().filter(kv -> kv.getKey().equals("ORCID")).collect(Collectors.toList()).size() > 0;
    }

    private void getNext() {
        this.resultId = this.author_iterator.hasNext() ? this.author_iterator.next() : "FINITO";
    }

    @Override
    public List<OafProtos.Oaf> next() {
        try {
            Emit e = Emit.fromJson(this.resultId);
            List<FieldTypeProtos.Author> author_list = this.getAuthorList(e);
            ResultProtos.Result.Metadata.Builder metadata = this.searchMatch(author_list);
            if (metadata != null) {
                ArrayList<OafProtos.Oaf> ret = new ArrayList<OafProtos.Oaf>(Arrays.asList(ResultOrcidIterator.getUpdate(metadata, e.getId())));
                this.getNext();
                return ret;
            }
        }
        catch (JsonFormat.ParseException parseException) {
            // empty catch block
        }
        this.getNext();
        return null;
    }

    private ResultProtos.Result.Metadata.Builder searchMatch(List<FieldTypeProtos.Author> author_list) {
        ResultProtos.Result.Metadata.Builder metadataBuilder = ResultProtos.Result.Metadata.newBuilder();
        boolean updated = false;
        for (FieldTypeProtos.Author a : author_list) {
            FieldTypeProtos.Author.Builder author = this.searchAuthor(a, this.autoritative_authors);
            if (author != null) {
                updated = true;
                metadataBuilder.addAuthor(author);
                continue;
            }
            metadataBuilder.addAuthor(FieldTypeProtos.Author.newBuilder((FieldTypeProtos.Author)a));
        }
        if (updated) {
            return metadataBuilder;
        }
        return null;
    }

    private boolean equals(FieldTypeProtos.Author a1, FieldTypeProtos.Author a2) {
        if (a1.hasSurname() && a2.hasSurname()) {
            if (!a1.getSurname().trim().equalsIgnoreCase(a2.getSurname().trim())) {
                return false;
            }
            if (a1.hasName() && a2.hasName()) {
                if (a1.getName().trim().equalsIgnoreCase(a2.getName().trim())) {
                    return true;
                }
                return a1.getName().trim().substring(0, 0).equalsIgnoreCase(a2.getName().trim().substring(0, 0));
            }
        }
        return false;
    }

    private FieldTypeProtos.Author.Builder searchAuthor(FieldTypeProtos.Author a, List<FieldTypeProtos.Author> author_list) {
        if (this.containsOrcid(a.getPidList())) {
            return null;
        }
        for (FieldTypeProtos.Author autoritative_author : author_list) {
            if (!this.equals(autoritative_author, a) || this.containsOrcid(a.getPidList())) continue;
            return this.update(a, autoritative_author);
        }
        return null;
    }

    private void analizeValueList() throws JsonFormat.ParseException {
        while (this.it.hasNext()) {
            Value v = Value.fromJson(((Text)this.it.next()).toString());
            if (v.getType().equals((Object)PropagationConstants.Type.fromresult)) {
                this.autoritative_authors.addAll(this.getAuthorList(Emit.fromJson(v.getValue())));
            }
            if (!v.getType().equals((Object)PropagationConstants.Type.fromsemrel)) continue;
            this.relatedResult.add(v.getValue());
        }
    }

    private FieldTypeProtos.Author.Builder update(FieldTypeProtos.Author related_author, FieldTypeProtos.Author autoritative_autor) {
        FieldTypeProtos.Author.Builder res = FieldTypeProtos.Author.newBuilder((FieldTypeProtos.Author)related_author);
        List apid_list = autoritative_autor.getPidList();
        FieldTypeProtos.KeyValue akv = (FieldTypeProtos.KeyValue)apid_list.stream().filter(kv -> kv.getKey().equals("ORCID")).collect(Collectors.toList()).get(0);
        FieldTypeProtos.KeyValue.Builder kvb = FieldTypeProtos.KeyValue.newBuilder();
        kvb.setKey(akv.getKey()).setValue(akv.getValue());
        kvb.setDataInfo(Utils.getDataInfo("0.85", "propagation:orcid:result", "dnet:provenanceActions", "dnet:provenanceActions", "propagation", "Propagation of ORCID through result linked by isSupplementedBy or isSupplementTo semantic relations"));
        return res.addPid(kvb);
    }

    private List<FieldTypeProtos.Author> getAuthorList(Emit e) throws JsonFormat.ParseException {
        ArrayList<FieldTypeProtos.Author> authors = new ArrayList<FieldTypeProtos.Author>();
        for (String author : e.getAuthor_list()) {
            FieldTypeProtos.Author.Builder author_builder = FieldTypeProtos.Author.newBuilder();
            JsonFormat.merge((CharSequence)author, (Message.Builder)author_builder);
            authors.add(author_builder.build());
        }
        return authors;
    }

    public static OafProtos.Oaf getUpdate(ResultProtos.Result.Metadata.Builder metadata, String resultId) {
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        OafProtos.OafEntity.Builder entity = OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId(resultId).setResult(result);
        return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setEntity(entity).build();
    }
}

