package eu.dnetlib.data.mapreduce.hbase.openorgs;

import java.nio.charset.Charset;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class OpenOrgsCommon {

	public static final String OPENORGS_MESH_PREFIX = "openorgsmesh::";
	public static final String OPENORGS_MAIN_PREFIX = "openorgs____::";
	public static final String OPENORGS_CORDA_FP7_PREFIX = "corda_______::";
	public static final String OPENORGS_CORDA_H2020_PREFIX = "corda__h2020::";

	public static boolean isOpenOrgsMesh(final ImmutableBytesWritable k) {
		return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|" + OPENORGS_MESH_PREFIX);
	}

	public static boolean isOpenOrgs(final ImmutableBytesWritable k) {
		return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|" + OPENORGS_MAIN_PREFIX);
	}

	public static boolean isCordaFp7(final ImmutableBytesWritable k) {
		return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|" + OPENORGS_CORDA_FP7_PREFIX);
	}

	public static boolean isCordaH2020(final ImmutableBytesWritable k) {
		return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|" + OPENORGS_CORDA_H2020_PREFIX);
	}

}
