/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.broker.enrich;

import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.hbase.broker.enrich.AbstractEnrichmentMapper;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class SoftwareEnrichmentMapper
extends AbstractEnrichmentMapper {
    public static final String SOFTWARE = "software";
    public static final String PUBLICATION = "publication";
    public static final String RESULT_RESULT_RELATIONSHIP_IS_RELATED_TO = "resultResult_relationship_isRelatedTo";

    @Override
    protected String counterGroup() {
        return "Broker Enrichment Software";
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = this.getEntityType(key);
        byte[] body = value.getValue(Bytes.toBytes((String)type.toString()), Bytes.toBytes((String)"body"));
        if (body == null) {
            context.getCounter(this.counterGroup(), "missing metadata").increment(1L);
            return;
        }
        switch (type) {
            case result: {
                OafProtos.Oaf oaf = OafDecoder.decode((byte[])body).getOaf();
                if (oaf.getDataInfo().getDeletedbyinference()) {
                    context.getCounter(this.counterGroup(), "result deletedbyinference").increment(1L);
                    return;
                }
                OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
                String resulttype = oafBuilder.getEntity().getResult().getMetadata().getResulttype().getClassid();
                if (SOFTWARE.equalsIgnoreCase(resulttype)) {
                    for (byte[] publicationId : this.listRelatedIds(value, RESULT_RESULT_RELATIONSHIP_IS_RELATED_TO)) {
                        this.emit(context, publicationId, body, SOFTWARE);
                    }
                    break;
                }
                if (!PUBLICATION.equalsIgnoreCase(resulttype)) break;
                for (String relName : Arrays.asList(RESULT_RESULT_RELATIONSHIP_IS_RELATED_TO)) {
                    this.listRelations(value, relName).forEach(rel -> {
                        oafBuilder.getEntityBuilder().addCachedOafRel(rel);
                        context.getCounter(this.counterGroup(), "rel: " + relName).increment(1L);
                    });
                }
                this.emit(context, key.copyBytes(), oafBuilder.build().toByteArray(), PUBLICATION);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type: " + type);
            }
        }
    }

    private Stream<OafProtos.Oaf> listRelations(Result value, String relType) {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)relType));
        return MapUtils.isEmpty((Map)map) ? Stream.empty() : map.values().stream().map(input -> OafDecoder.decode((byte[])input).getOaf()).filter(rel -> !rel.getRel().getTarget().contains("unidentified"));
    }

    private Iterable<byte[]> listRelatedIds(Result value, String relType) {
        NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)relType));
        return MapUtils.isNotEmpty((Map)map) ? map.keySet() : Lists.newArrayList();
    }

    private TypeProtos.Type getEntityType(ImmutableBytesWritable key) {
        return OafRowKeyDecoder.decode((byte[])key.copyBytes()).getType();
    }
}

