package eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware;

import com.google.gson.Gson;

import java.util.List;

public class SoftwareResource {
    private String openAireId;
    private List<Identifier> softwarePIDs;
    private List<String> urls;


    public SoftwareResource() {
    }

    public String getOpenAireId() {
        return openAireId;
    }

    public SoftwareResource setOpenAireId(String openAireId) {
        this.openAireId = openAireId;
        return this;
    }

    public List<Identifier> getSoftwarePIDs() {
        return softwarePIDs;
    }

    public SoftwareResource setSoftwarePIDs(List<Identifier> softwarePIDs) {
        this.softwarePIDs = softwarePIDs;
        return this;
    }

    public List<String> getUrls() {
        return urls;
    }

    public SoftwareResource setUrls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    public String toJson() {
        return new Gson().toJson(this);
    }

    public static SoftwareResource fromJson(final String json) {
        return new Gson().fromJson(json, SoftwareResource.class);
    }

}
