/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafRelDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.OafUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class OafHbaseUtils
extends OafUtils {
    public static OafDecoder decode(ImmutableBytesWritable oaf) {
        return new OafDecoder(oaf.copyBytes());
    }

    public static Function<ImmutableBytesWritable, OafDecoder> decoder() {
        return input -> OafDecoder.decode((byte[])input.copyBytes());
    }

    public static Iterable<OafProtos.Oaf> asOaf(Iterable<ImmutableBytesWritable> in) {
        return Iterables.transform(in, OafHbaseUtils.oafDecoder());
    }

    public static Function<ImmutableBytesWritable, OafProtos.Oaf> oafDecoder() {
        return input -> OafHbaseUtils.parse(input);
    }

    public static OafProtos.Oaf parse(ImmutableBytesWritable input) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])input.copyBytes());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> String getValue(T t) {
        return OafHbaseUtils.mapValue(t);
    }

    public static <T> String getKey(T t) {
        return OafHbaseUtils.mapKey(t);
    }

    public static <T> String getValue(Iterable<T> ts) {
        return (String)Iterables.getFirst(OafHbaseUtils.listValues(ts), (Object)"");
    }

    public static <T> Set<String> hashSetValues(Iterable<T> ts) {
        return Sets.newHashSet((Iterable)Iterables.transform(ts, t -> OafHbaseUtils.mapValue(t)));
    }

    public static <T> List<String> listValues(Iterable<T> ts) {
        return Lists.newArrayList((Iterable)Iterables.transform(ts, t -> OafHbaseUtils.mapValue(t)));
    }

    public static <T> List<String> listObjects(Iterable<T> ts) {
        return Lists.newArrayList((Iterable)Iterables.transform(ts, t -> OafHbaseUtils.mapObject(t)));
    }

    public static <T> String getKey(Iterable<T> ts) {
        return (String)Iterables.getFirst(OafHbaseUtils.listKeys(ts), (Object)"");
    }

    public static <T> List<String> listKeys(Iterable<T> ts) {
        return Lists.newArrayList((Iterable)Iterables.transform(ts, t -> OafHbaseUtils.mapKey(t)));
    }

    public static <T> Set<String> hashSetKeys(Iterable<T> ts) {
        return Sets.newHashSet((Iterable)Iterables.transform(ts, t -> OafHbaseUtils.mapKey(t)));
    }

    private static <T> String mapKey(T t) {
        if (t instanceof FieldTypeProtos.KeyValue) {
            return ((FieldTypeProtos.KeyValue)t).getKey();
        }
        if (t instanceof String) {
            return (String)t;
        }
        if (t instanceof FieldTypeProtos.Qualifier) {
            return ((FieldTypeProtos.Qualifier)t).getClassid();
        }
        throw new IllegalArgumentException(String.format("type %s not mapped", t.getClass()));
    }

    public static <T> String mapValue(T t) {
        if (t instanceof FieldTypeProtos.StructuredProperty) {
            return ((FieldTypeProtos.StructuredProperty)t).getValue();
        }
        if (t instanceof FieldTypeProtos.KeyValue) {
            return ((FieldTypeProtos.KeyValue)t).getValue();
        }
        if (t instanceof String) {
            return (String)t;
        }
        if (t instanceof FieldTypeProtos.StringField) {
            return ((FieldTypeProtos.StringField)t).getValue();
        }
        if (t instanceof FieldTypeProtos.Qualifier) {
            return ((FieldTypeProtos.Qualifier)t).getClassname();
        }
        if (t instanceof FieldTypeProtos.Author) {
            FieldTypeProtos.Author a = (FieldTypeProtos.Author)t;
            if (a.getPidCount() == 0) {
                return a.getFullname();
            }
            return a.getFullname() + " " + OafHbaseUtils.listObjects(a.getPidList());
        }
        throw new IllegalArgumentException(String.format("type %s not mapped", t.getClass()));
    }

    public static <T> String mapObject(T t) {
        if (t instanceof FieldTypeProtos.KeyValue) {
            FieldTypeProtos.KeyValue kv = (FieldTypeProtos.KeyValue)t;
            return kv.getKey() + ":" + kv.getValue();
        }
        if (t instanceof String) {
            return (String)t;
        }
        throw new IllegalArgumentException(String.format("type %s not mapped", t.getClass()));
    }

    public static List<String> getPropertyValues(Reducer.Context context, String name) {
        return OafHbaseUtils.doGetPropertyValues(context.getConfiguration().get(name, ""));
    }

    public static List<String> getPropertyValues(Mapper.Context context, String name) {
        return OafHbaseUtils.doGetPropertyValues(context.getConfiguration().get(name, ""));
    }

    private static List<String> doGetPropertyValues(String s) {
        return Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)s));
    }

    public static List<OafProtos.Oaf> rel(Result value) {
        return value.list().stream().filter(kv -> {
            String q = new String(kv.getQualifier());
            return q.matches("^[0-9][0-9]\\|.{12}::[a-zA-Z0-9]{32}$");
        }).filter(kv -> kv.getValue() != null && kv.getValue().length > 0).map(kv -> OafHbaseUtils.parseProto(kv.getValue())).collect(Collectors.toList());
    }

    public static OafProtos.Oaf parseProto(byte[] value) {
        OafDecoder d = OafDecoder.decode((byte[])value);
        return d.getOaf();
    }

    public static Put asPut(OafProtos.Oaf oaf) {
        switch (oaf.getKind()) {
            case entity: {
                Put entity = OafHbaseUtils.getPut(oaf.getEntity().getId());
                byte[] cf = Bytes.toBytes((String)oaf.getEntity().getType().toString());
                return entity.add(cf, DedupUtils.BODY_B, oaf.toByteArray());
            }
            case relation: {
                OafProtos.OafRel rel = oaf.getRel();
                Put putRel = OafHbaseUtils.getPut(rel.getSource());
                OafRelDecoder relDecoder = OafRelDecoder.decode((OafProtos.OafRel)rel);
                byte[] cfRel = Bytes.toBytes((String)relDecoder.getCFQ());
                byte[] qualifier = Bytes.toBytes((String)rel.getTarget());
                return putRel.add(cfRel, qualifier, oaf.toByteArray());
            }
        }
        throw new IllegalArgumentException("invalid kind");
    }

    private static Put getPut(String rowkey) {
        Put put = new Put(Bytes.toBytes((String)rowkey));
        put.setDurability(Durability.USE_DEFAULT);
        return put;
    }

    public static byte[] getBodyB(Result value, TypeProtos.Type type) {
        return value.getValue(Bytes.toBytes((String)type.toString()), DedupUtils.BODY_B);
    }

    public static OafProtos.Oaf getBody(Result value, TypeProtos.Type type) throws InvalidProtocolBufferException {
        byte[] body = OafHbaseUtils.getBodyB(value, type);
        return body != null ? OafHbaseUtils.parseProto(body) : null;
    }
}

