package eu.dnetlib.data.mapreduce.hbase.openorgs;

import org.apache.commons.lang.StringUtils;

import eu.dnetlib.data.proto.OafProtos.Oaf;

public class GenerateSimilaritiesMapper extends AbstractOpenOrgsMapper {

	@Override
	protected String calculateKeyOut(final Oaf oaf, final String rootId, final Context context) {

		if (oaf.getDataInfo().getDeletedbyinference() && StringUtils.isNotBlank(rootId)) {
			context.getCounter("organization", "deletedbyinference = true").increment(1);
			return rootId;
		} else {
			return null;
		}
	}

}
