/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.openorgs;

import java.nio.charset.Charset;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class OpenOrgsCommon {
    public static final String OPENORGS_MESH_PREFIX = "openorgsmesh::";
    public static final String OPENORGS_MAIN_PREFIX = "openorgs____::";
    public static final String OPENORGS_CORDA_FP7_PREFIX = "corda_______::";
    public static final String OPENORGS_CORDA_H2020_PREFIX = "corda__h2020::";

    public static boolean isOpenOrgsMesh(ImmutableBytesWritable k) {
        return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|openorgsmesh::");
    }

    public static boolean isOpenOrgs(ImmutableBytesWritable k) {
        return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|openorgs____::");
    }

    public static boolean isCordaFp7(ImmutableBytesWritable k) {
        return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|corda_______::");
    }

    public static boolean isCordaH2020(ImmutableBytesWritable k) {
        return new String(k.copyBytes(), Charset.forName("UTF-8")).startsWith("20|corda__h2020::");
    }
}

