/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts;

import com.google.gson.Gson;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.hbase.propagation.orcidthroughproducts.Emit;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PropagationOrcidToResultMapper
extends TableMapper<ImmutableBytesWritable, Text> {
    private static final Log log = LogFactory.getLog(PropagationOrcidToResultMapper.class);
    private Text valueOut;
    private ImmutableBytesWritable keyOut;
    private String[] sem_rels;
    private String trust;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.valueOut = new Text();
        this.keyOut = new ImmutableBytesWritable();
        this.sem_rels = context.getConfiguration().getStrings("propagatetoorcid.semanticrelations", PropagationConstants.DEFAULT_RESULT_RELATION_SET);
        this.trust = context.getConfiguration().get("propagatetoorcid.trust", "0.85");
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes()).getType();
        OafProtos.OafEntity entity = Utils.getEntity(value, type);
        if (entity != null && type == TypeProtos.Type.result) {
            HashSet<String> result_result = new HashSet<String>();
            for (String sem : this.sem_rels) {
                result_result.addAll(Utils.getRelationTarget(value, sem, context, "Propagation"));
            }
            if (!result_result.isEmpty()) {
                List<String> authorlist = this.getAuthorList(entity.getResult().getMetadata().getAuthorList());
                Emit e = new Emit();
                e.setId(Bytes.toString((byte[])keyIn.get()));
                e.setAuthor_list(authorlist);
                this.valueOut.set(Value.newInstance(new Gson().toJson((Object)e, Emit.class), this.trust, PropagationConstants.Type.fromsemrel).toJson());
                for (String result : result_result) {
                    this.keyOut.set(Bytes.toBytes((String)result));
                    context.write((Object)this.keyOut, (Object)this.valueOut);
                    context.getCounter("Propagation", "emit for sem_rel").increment(1L);
                }
                e.setId(keyIn.toString());
                e.setAuthor_list(authorlist);
                this.valueOut.set(Value.newInstance(new Gson().toJson((Object)e, Emit.class), this.trust, PropagationConstants.Type.fromresult).toJson());
                context.write((Object)keyIn, (Object)this.valueOut);
                context.getCounter("Propagation", "emit for result with orcid").increment(1L);
            }
        }
    }

    private List<String> getAuthorList(List<FieldTypeProtos.Author> author_list) {
        return author_list.stream().map(a -> {
            new JsonFormat();
            return JsonFormat.printToString((Message)a);
        }).collect(Collectors.toList());
    }
}

