/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.propagation.projecttoresult;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants;
import eu.dnetlib.data.mapreduce.hbase.propagation.Utils;
import eu.dnetlib.data.mapreduce.hbase.propagation.Value;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class ProjectToResultMapper
extends TableMapper<ImmutableBytesWritable, Text> {
    private static final String SEPARATOR = ",";
    private String[] sem_rels;
    private String trust;
    private ImmutableBytesWritable keyOut;
    private Text valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.keyOut = new ImmutableBytesWritable();
        this.valueOut = new Text();
        this.sem_rels = context.getConfiguration().getStrings("propagatetoproject.semanticrelations", PropagationConstants.DEFAULT_PROJECT_RELATION_SET);
        this.trust = context.getConfiguration().get("propagatetoproject.trust", "0.85");
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        TypeProtos.Type type = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes()).getType();
        if (!type.equals((Object)TypeProtos.Type.result)) {
            return;
        }
        OafProtos.OafEntity entity = Utils.getEntity(value, type);
        if (entity == null) {
            context.getCounter("Propagation", "Del by inference or null body for result").increment(1L);
            return;
        }
        context.getCounter("Propagation", "Valid result ").increment(1L);
        String projectIdList = this.getProjectIdList(value, context);
        if (StringUtils.isNotBlank((CharSequence)projectIdList)) {
            HashSet<String> toemitrelations = new HashSet<String>();
            for (String sem_rel : this.sem_rels) {
                toemitrelations.addAll(this.getRelationTarget(value, sem_rel, context));
            }
            if (!toemitrelations.isEmpty()) {
                this.emit(context, toemitrelations, projectIdList);
                context.getCounter("Propagation", "emit for semantic relation").increment((long)toemitrelations.size());
            }
            this.keyOut.set(entity.getId().getBytes());
            this.valueOut.set(Value.newInstance(projectIdList, PropagationConstants.Type.fromresult).toJson());
            context.write((Object)this.keyOut, (Object)this.valueOut);
            context.getCounter("Propagation", "emit for result").increment(1L);
        }
    }

    private void emit(Mapper.Context context, Set<String> toemitrelations, String projectIdList) throws IOException, InterruptedException {
        for (String relation : toemitrelations) {
            this.keyOut.set(relation.getBytes());
            this.valueOut.set(Value.newInstance(projectIdList, this.trust, PropagationConstants.Type.fromsemrel).toJson());
            context.write((Object)this.keyOut, (Object)this.valueOut);
        }
    }

    private String getProjectIdList(Result value, Mapper.Context context) throws InvalidProtocolBufferException {
        Set<String> ret = this.getRelationTarget(value, PropagationConstants.OUTCOME_PRODUCEDBY, context);
        return ret.size() == 0 ? null : String.join((CharSequence)SEPARATOR, ret);
    }

    private Set<String> getRelationTarget(Result value, String sem_rel, Mapper.Context context) throws InvalidProtocolBufferException {
        NavigableMap relationMap = value.getFamilyMap(Bytes.toBytes((String)sem_rel));
        context.getCounter("Propagation", sem_rel).increment((long)relationMap.size());
        return relationMap.values().stream().map(this::asOaf).filter(Objects::nonNull).filter(o -> this.isValid((OafProtos.Oaf)o)).filter(o -> !o.getDataInfo().getDeletedbyinference()).map(o -> o.getRel().getTarget()).collect(Collectors.toCollection(HashSet::new));
    }

    private OafProtos.Oaf asOaf(byte[] r) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])r);
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    private boolean isValid(OafProtos.Oaf oaf) {
        return oaf != null && oaf.isInitialized();
    }
}

