package eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware;

import com.google.gson.Gson;
import eu.dnetlib.data.mapreduce.hbase.dataexport.linkinganalysis.publicationsoftware.Constants.Type;

public class Value {

    private String value;//json

    private Type type;//publication or software

    public Value() {
    }



    public String getValue() {
        return value;
    }

    public Value setValue(String value) {
        this.value = value;
        return this;
    }

    public static Value newInstance(String value, Type type) {
        return new Value().setValue(value).setType(type);
    }


    public static Value fromJson(final String json) {
        return new Gson().fromJson(json, Value.class);
    }

    public String toJson() {
        return new Gson().toJson(this);
    }

    public Constants.Type getType() {
        return type;
    }

    public Value setType(Constants.Type type) {
        this.type = type;
        return this;
    }

}
