package eu.dnetlib.data.mapreduce.hbase.propagation.organizationtoresult.datasource;

import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.mapreduce.hbase.propagation.NotValidResultSequenceException;
import eu.dnetlib.data.mapreduce.hbase.propagation.ResultIterator;
import eu.dnetlib.data.mapreduce.hbase.propagation.compositekeys.InstOrgKey;
import eu.dnetlib.data.proto.OafProtos;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

import java.io.IOException;
import java.util.List;

import static eu.dnetlib.data.mapreduce.hbase.propagation.PropagationConstants.COUNTER_PROPAGATION;

//public class PropagationProductToOrganizationFileReducer extends Reducer<ImmutableBytesWritable, Text, Text,Text> {
public class PropagationProductToOrganizationFileReducer extends Reducer<InstOrgKey, Text, Text,Text> {
    private static final Log log = LogFactory.getLog(PropagationProductToOrganizationFileReducer.class); // NOPMD by marko on 11/24/08 5:02 PM

    private Text keyOut;
    private Text outValue;


    @Override
    protected void setup(final Context context) throws IOException, InterruptedException {
        super.setup(context);
        keyOut = new Text("");
        outValue = new Text();
    }


    @Override
    //protected void reduce(ImmutableBytesWritable key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
    protected void reduce(InstOrgKey key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
        ResultIterator rh = null;
        try {
            rh = new ResultOrganizationIterator(values, key.getKeyType().get());
        } catch (NotValidResultSequenceException e) {
            context.getCounter(COUNTER_PROPAGATION, e.getMessage()).increment(1);
            return;
        }
        while (rh.hasNext()) {
            List<OafProtos.Oaf> oafList = rh.next();
            for (OafProtos.Oaf oaf : oafList) {
                keyOut.set(oaf.getRel().getSource());
                outValue.set(JsonFormat.printToString(oaf).getBytes());
                context.write(keyOut, outValue);
            }
            context.getCounter(COUNTER_PROPAGATION, "Added result to organizationtoresult").increment(oafList.size()/2);
        }

    }
}
