/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafHbaseUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Reducer;

public class InfospaceCountsReducer
extends Reducer<Text, ImmutableBytesWritable, NullWritable, NullWritable> {
    public static final String ENTITY = KindProtos.Kind.entity.toString();

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) {
        try {
            OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((String)key.toString());
            block6: for (ImmutableBytesWritable bytes : values) {
                OafDecoder decoder = OafHbaseUtils.decode(bytes);
                TypeProtos.Type type = keyDecoder.getType();
                OafProtos.Oaf oaf = decoder.getOaf();
                switch (decoder.getKind()) {
                    case entity: {
                        if (this.deletedByInference(oaf)) {
                            if (this.isInvisible(oaf)) {
                                this.incrementCounter(context, ENTITY, String.format("%s (deleted true / invisible true)", this.getEntityType(oaf, type)), 1);
                                continue block6;
                            }
                            this.incrementCounter(context, ENTITY, String.format("%s (deleted true / invisible false)", this.getEntityType(oaf, type)), 1);
                            continue block6;
                        }
                        if (this.isInvisible(oaf)) {
                            this.incrementCounter(context, ENTITY, String.format("%s (deleted false / invisible true)", this.getEntityType(oaf, type)), 1);
                            continue block6;
                        }
                        this.incrementCounter(context, ENTITY, String.format("%s (deleted false / invisible false)", this.getEntityType(oaf, type)), 1);
                        continue block6;
                    }
                    case relation: {
                        if (this.deletedByInference(oaf)) {
                            this.incrementCounter(context, String.format("%s (deleted true)", ENTITY), decoder.getCFQ(), 1);
                            continue block6;
                        }
                        this.incrementCounter(context, String.format("%s (deleted false)", ENTITY), decoder.getCFQ(), 1);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("unknow type: " + decoder.getKind());
            }
        }
        catch (Throwable e) {
            context.getCounter("error", e.getClass().getName()).increment(1L);
            throw new RuntimeException(e);
        }
    }

    private void incrementCounter(Reducer.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Reducer.Context context, String k, String t) {
        return context.getCounter(k, t);
    }

    private String getEntityType(OafProtos.Oaf oaf, TypeProtos.Type type) {
        switch (type) {
            case result: {
                return oaf.getEntity().getResult().getMetadata().getResulttype().getClassid();
            }
        }
        return type.toString();
    }

    private boolean deletedByInference(OafProtos.Oaf oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private boolean isInvisible(OafProtos.Oaf oaf) {
        return oaf.getDataInfo().getInvisible();
    }
}

