/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.misc;

import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.util.DedupUtils;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import java.io.IOException;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class PredatoryJournalsMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private static final Log log = LogFactory.getLog(PredatoryJournalsMapper.class);
    private static final String PREDATORY_JOURNALS = "Predatory Journal Counters";
    private static final byte[] isProducedBy = "resultProject_outcome_isProducedBy".getBytes();
    private Text keyOut;
    private ImmutableBytesWritable valueOut;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.keyOut = new Text("");
        this.valueOut = new ImmutableBytesWritable();
    }

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        block7: {
            try {
                OafProtos.Oaf oaf;
                OafRowKeyDecoder keyDecoder = OafRowKeyDecoder.decode((byte[])keyIn.copyBytes());
                byte[] body = value.getValue(keyDecoder.getType().toString().getBytes(), DedupUtils.BODY_B);
                if (body == null || !(oaf = OafProtos.Oaf.parseFrom((byte[])body)).getDataInfo().getDeletedbyinference()) break block7;
                switch (keyDecoder.getType()) {
                    case result: {
                        NavigableMap projectRels = value.getFamilyMap(isProducedBy);
                        if (projectRels == null) break;
                        long ecProjects = projectRels.keySet().stream().map(String::new).filter(s -> StringUtils.contains((String)s, (String)"corda")).count();
                        HashSet ids = Sets.newHashSet();
                        if (ecProjects > 0L) {
                            ids.addAll(Stream.concat(oaf.getEntity().getCollectedfromList().stream().map(FieldTypeProtos.KeyValue::getKey), oaf.getEntity().getResult().getInstanceList().stream().map(ResultProtos.Result.Instance::getHostedby).map(FieldTypeProtos.KeyValue::getKey)).collect(Collectors.toList()));
                            ids.forEach(dsId -> {
                                this.emit(context, (String)dsId, Bytes.toBytes((int)1));
                                context.getCounter(PREDATORY_JOURNALS, "publications").increment(1L);
                            });
                        }
                        break;
                    }
                    case datasource: {
                        DatasourceProtos.Datasource ds = oaf.getEntity().getDatasource();
                        String dsType = ds.getMetadata().getDatasourcetype().getClassid();
                        if (!StringUtils.contains((String)dsType, (String)"journal")) break;
                        this.emit(context, oaf.getEntity().getId(), body);
                        context.getCounter(PREDATORY_JOURNALS, "journals").increment(1L);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)("error exporting the following record from HBase: " + value.toString()), e);
                context.getCounter("error", e.getClass().getName()).increment(1L);
                throw new RuntimeException(e);
            }
        }
    }

    private void emit(Mapper.Context context, String key, byte[] value) {
        this.keyOut.set(key);
        this.valueOut.set(value);
        try {
            context.write((Object)this.keyOut, (Object)this.valueOut);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

