package eu.dnetlib.data.mapreduce;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class HadoopJobEnumerator implements BeanFactoryAware {

	private static final Log log = LogFactory.getLog(HadoopJobEnumerator.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * bean factory.
	 */
	private ListableBeanFactory beanFactory;

	/**
	 * Get all beans implementing the ConfiguredJob interface.
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Map<String, HadoopJob> getAll() {
		return beanFactory.getBeansOfType(HadoopJob.class);
	}

	@Override
	public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
		this.beanFactory = (ListableBeanFactory) beanFactory;
	}

	public ListableBeanFactory getBeanFactory() {
		return beanFactory;
	}

	/**
	 * Get given enableable or null.
	 * 
	 * @param name
	 * @return
	 */
	public HadoopJob get(final String name) {
		try {
			return (HadoopJob) beanFactory.getBean(name, HadoopJob.class);
		} catch (final NoSuchBeanDefinitionException e) {
			log.error("undefined bean: " + name, e);
			return null;
		}
	}
}
