package eu.dnetlib.data.collector.plugins;

import java.io.BufferedInputStream;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;

public class HttpCollectorPlugin extends AbstractSplittedRecordPlugin {

	@Override
	protected BufferedInputStream getBufferedInputStream(final String baseUrl) throws CollectorServiceException {
		try {
			final HttpClient client = new HttpClient();
			final HttpMethod method = new GetMethod(baseUrl);
			final int responseCode = client.executeMethod(method);

			if (HttpStatus.SC_OK != responseCode) { throw new CollectorServiceException("Error " + responseCode + " dowloading url: " + baseUrl); }
			return new BufferedInputStream(method.getResponseBodyAsStream());
		} catch (Exception e) {
			throw new CollectorServiceException("Error dowloading url: " + baseUrl);
		}
	}

}
