/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HttpCSVCollectorPlugin
extends AbstractCollectorPlugin {
    private static final Log log = LogFactory.getLog(HttpCSVCollectorPlugin.class);
    public static final String UTF8_BOM = "\ufeff";

    public Iterable<String> collect(InterfaceDescriptor descriptor, String fromDate, String untilDate) throws CollectorServiceException {
        return new HTTPCSVIterator(descriptor);
    }

    class HTTPCSVIterator
    implements Iterable<String> {
        private InterfaceDescriptor descriptor;

        public HTTPCSVIterator(InterfaceDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                String separator = (String)this.descriptor.getParams().get("separator");
                final String identifier = (String)this.descriptor.getParams().get("identifier");
                String quote = (String)this.descriptor.getParams().get("quote");
                URL url = new URL(this.descriptor.getBaseUrl());
                long nLines = 0L;
                final File tempFile = File.createTempFile("csv-", ".tmp");
                try (InputStream is = url.openConnection().getInputStream();
                     BOMInputStream bomIs = new BOMInputStream(is);
                     BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)bomIs));
                     FileWriter fw = new FileWriter(tempFile);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!StringUtils.isBlank((String)quote) && quote.charAt(0) == '\"' && !this.verifyQuotes(line)) continue;
                        fw.write(line);
                        fw.write("\n");
                        ++nLines;
                    }
                }
                CSVFormat format = CSVFormat.EXCEL.withHeader(new String[0]).withDelimiter(separator.equals("\\t") || StringUtils.isBlank((String)separator) ? (char)'\t' : separator.charAt(0)).withQuote(StringUtils.isBlank((String)quote) ? null : Character.valueOf(quote.charAt(0))).withTrim();
                final CSVParser parser = new CSVParser((Reader)new FileReader(tempFile), format);
                final Set headers = parser.getHeaderMap().keySet();
                final long nRecords = nLines - 1L;
                return Iterators.transform((Iterator)parser.iterator(), (Function)new Function<CSVRecord, String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String apply(CSVRecord input) {
                        try {
                            Document document = DocumentHelper.createDocument();
                            Element root = document.addElement("csvRecord");
                            for (String key : headers) {
                                Element row = root.addElement("column");
                                row.addAttribute("name", key).addText(input.get(key));
                                if (!key.equals(identifier)) continue;
                                row.addAttribute("isID", "true");
                            }
                            String string = document.asXML();
                            return string;
                        }
                        finally {
                            System.out.println(tempFile.getAbsolutePath());
                            if (parser.getRecordNumber() == nRecords) {
                                System.out.println("DELETING " + tempFile.getAbsolutePath());
                                tempFile.delete();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)"Error iterating csv lines", (Throwable)e);
                return null;
            }
        }

        private boolean verifyQuotes(String line) {
            char[] cs = line.trim().toCharArray();
            boolean inField = false;
            boolean skipNext = false;
            for (int i = 0; i < cs.length; ++i) {
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                if (inField) {
                    if (cs[i] == '\"' && (i == cs.length - 1 || cs[i + 1] == ',')) {
                        inField = false;
                        continue;
                    }
                    if (cs[i] != '\"' || i >= cs.length - 1) continue;
                    if (cs[i + 1] == '\"') {
                        skipNext = true;
                        continue;
                    }
                    log.warn((Object)("Skipped invalid line: " + line));
                    return false;
                }
                if (cs[i] != '\"' || i != 0 && cs[i - 1] != ',') continue;
                inField = true;
            }
            if (inField) {
                log.warn((Object)("Skipped invalid line: " + line));
                return false;
            }
            return true;
        }
    }
}

