/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(FileSystemIterator.class);
    private Set<String> extensions = Sets.newHashSet();
    private Iterator<Path> pathIterator;
    private String current;

    public FileSystemIterator(String baseDir, String extensions) {
        if (StringUtils.isNotBlank((String)extensions)) {
            this.extensions = Sets.newHashSet((Object[])extensions.split(","));
        }
        try {
            this.pathIterator = Files.newDirectoryStream(Paths.get(baseDir, new String[0])).iterator();
            this.current = this.walkTillNext();
        }
        catch (IOException e) {
            log.error((Object)("Cannot initialize File System Iterator. Is this path correct? " + baseDir));
            throw new RuntimeException("Filesystem collection error.", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public synchronized String next() {
        String pivot = new String(this.current);
        this.current = this.walkTillNext();
        log.debug((Object)("Returning: " + pivot));
        return pivot;
    }

    @Override
    public void remove() {
    }

    private synchronized String walkTillNext() {
        while (this.pathIterator.hasNext()) {
            Path nextFilePath = this.pathIterator.next();
            if (Files.isDirectory(nextFilePath, new LinkOption[0])) {
                try {
                    this.pathIterator = Iterators.concat(this.pathIterator, Files.newDirectoryStream(nextFilePath).iterator());
                    log.debug((Object)("Adding folder iterator: " + nextFilePath.toString()));
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)("Cannot create folder iterator! Is this path correct? " + nextFilePath.toString()));
                    return null;
                }
            }
            if (!this.extensions.isEmpty() && !this.extensions.contains(FilenameUtils.getExtension((String)nextFilePath.toString()))) continue;
            log.debug((Object)("Returning: " + nextFilePath.toString()));
            return nextFilePath.toString();
        }
        return null;
    }
}

