/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.sftp;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.sftp.SftpIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;
import java.util.Set;

public class SftpCollectorPlugin
extends AbstractCollectorPlugin {
    private SftpIteratorFactory sftpIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, final String fromDate, String toDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String username = (String)interfaceDescriptor.getParams().get("username");
        final String password = (String)interfaceDescriptor.getParams().get("password");
        final String recursive = (String)interfaceDescriptor.getParams().get("recursive");
        final String extensions = (String)interfaceDescriptor.getParams().get("extensions");
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new CollectorServiceException("Param 'username' is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new CollectorServiceException("Param 'password' is null or empty");
        }
        if (recursive == null || recursive.isEmpty()) {
            throw new CollectorServiceException("Param 'recursive' is null or empty");
        }
        if (extensions == null || extensions.isEmpty()) {
            throw new CollectorServiceException("Param 'extensions' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        return new Iterable<String>(){
            boolean isRecursive;
            Set<String> extensionsSet;
            {
                this.isRecursive = "true".equals(recursive);
                this.extensionsSet = this.parseSet(extensions);
            }

            @Override
            public Iterator<String> iterator() {
                return SftpCollectorPlugin.this.getSftpIteratorFactory().newIterator(baseUrl, username, password, this.isRecursive, this.extensionsSet, fromDate);
            }

            private Set<String> parseSet(String extensions2) {
                return Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)extensions2));
            }
        };
    }

    public SftpIteratorFactory getSftpIteratorFactory() {
        return this.sftpIteratorFactory;
    }

    public void setSftpIteratorFactory(SftpIteratorFactory sftpIteratorFactory) {
        this.sftpIteratorFactory = sftpIteratorFactory;
    }
}

