package eu.dnetlib.data.collector.plugins.httplist;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class HttpListIterator implements Iterator<String> {

	final HttpClient client = new HttpClient();

	private String baseUrl;
	private String currentLine;
	private BufferedReader reader;

	public HttpListIterator(final String baseUrl, final String listAddress) {
		try {
			this.baseUrl = baseUrl;
			this.reader = new BufferedReader(new StringReader(download(listAddress)));
			this.currentLine = reader.readLine();
		} catch (Exception e) {
			throw new RuntimeException("Error creating iterator", e);
		}
	}

	@Override
	public synchronized boolean hasNext() {
		return StringUtils.isNotBlank(currentLine);
	}

	@Override
	public synchronized String next() {
		try {
			if (StringUtils.isNotBlank(currentLine)) {
				return download(baseUrl + currentLine);
			} else {
				throw new RuntimeException("Iterator has reached the end");
			}
		} finally {
			try {
				this.currentLine = reader.readLine();
			} catch (IOException e) {
				throw new RuntimeException("Error obtaining next element " + currentLine, e);
			}
		}
	}

	private String download(final String url) {
		try {
			final HttpMethod method = new GetMethod(url);
			final int responseCode = client.executeMethod(method);
			if (responseCode == HttpStatus.SC_OK) {
				return IOUtils.toString(new BufferedInputStream(method.getResponseBodyAsStream()));
			} else {
				throw new RuntimeException("Error " + responseCode + " dowloading url: " + url);
			}
		} catch (IOException e) {
			throw new RuntimeException("Error dowloading url: " + url);
		}
	}

	@Override
	public void remove() {}

}
