/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import eu.dnetlib.data.collector.plugins.filesystem.FileSystemIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.json.XML;

public class FilesystemIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(FilesystemIterable.class);
    private File baseDir;
    private String extensions;
    private String fileFormat = "xml";
    private List<String> supportedFormats = Lists.newArrayList((Object[])new String[]{"xml", "json"});
    private boolean setObjIdentifierFromFileName = false;

    public FilesystemIterable(InterfaceDescriptor descriptor) throws CollectorServiceException {
        try {
            String baseUrl = descriptor.getBaseUrl();
            URL basePath = new URL(baseUrl);
            this.baseDir = new File(basePath.getPath());
            if (!this.baseDir.exists()) {
                throw new CollectorServiceException(String.format("The base ULR %s, does not exist", basePath.getPath()));
            }
            this.extensions = (String)descriptor.getParams().get("extensions");
            if (descriptor.getParams().containsKey("fileFormat")) {
                this.fileFormat = (String)descriptor.getParams().get("fileFormat");
            }
            if (!this.supportedFormats.contains(this.fileFormat)) {
                throw new CollectorServiceException("File format " + this.fileFormat + " not supported. Supported formats are: " + StringUtils.join(this.supportedFormats, (char)','));
            }
            if (descriptor.getParams().containsKey("setObjIdentifierFromFileName")) {
                this.setObjIdentifierFromFileName = Boolean.parseBoolean((String)descriptor.getParams().get("setObjIdentifierFromFileName"));
            }
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("Filesystem collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        FileSystemIterator fsi = new FileSystemIterator(this.baseDir.getAbsolutePath(), this.extensions);
        return Iterators.transform((Iterator)fsi, inputFileName -> {
            String string;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((String)inputFileName);
                String s = IOUtils.toString((InputStream)fileInputStream);
                if (this.fileFormat.equalsIgnoreCase("json")) {
                    JSONObject json = new JSONObject(s);
                    JSONObject obj = new JSONObject();
                    if (this.setObjIdentifierFromFileName) {
                        obj.put("header", (Object)new JSONObject().put("objIdentifier", (Object)FilenameUtils.getBaseName((String)inputFileName)));
                    }
                    obj.put("metadata", (Object)json);
                    log.debug((Object)obj.toString());
                    String string2 = XML.toString((Object)obj, (String)"record");
                    return string2;
                }
                String cleanedXML = XmlCleaner.cleanAllEntities(s.startsWith("\ufeff") ? s.substring(1) : s);
                if (this.setObjIdentifierFromFileName) {
                    String obj = this.addObjIdentifier(cleanedXML, FilenameUtils.getBaseName((String)inputFileName));
                    return obj;
                }
                String obj = cleanedXML;
                return obj;
            }
            catch (VTDException e) {
                log.error((Object)("Cannot process with VTD to set the objIdentifier " + inputFileName));
                string = "";
                return string;
            }
            catch (Exception e) {
                log.error((Object)("Unable to read " + inputFileName));
                string = "";
                return string;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Unable to close inputstream for  " + inputFileName));
                    }
                }
            }
        });
    }

    private String addObjIdentifier(String xml, String objidentifier) throws VTDException, IOException {
        VTDGen vg = new VTDGen();
        XMLModifier xm = new XMLModifier();
        vg.setDoc(xml.getBytes("UTF-8"));
        vg.parse(false);
        VTDNav vn = vg.getNav();
        xm.bind(vn);
        if (vn.toElement(0)) {
            xm.insertBeforeElement("<record><header><objIdentifier>" + objidentifier + "</objIdentifier></header><metadata>");
            xm.insertAfterElement("</metadata></record>");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xm.output((OutputStream)baos);
        return baos.toString("UTF-8");
    }
}

