/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.httplist;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpListIterator
implements Iterator<String> {
    final HttpClient client = new HttpClient();
    private String baseUrl;
    private String currentLine;
    private BufferedReader reader;

    public HttpListIterator(String baseUrl, String listAddress) {
        try {
            this.baseUrl = baseUrl;
            this.reader = new BufferedReader(new StringReader(this.download(listAddress)));
            this.currentLine = this.reader.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating iterator", e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return StringUtils.isNotBlank((CharSequence)this.currentLine);
    }

    @Override
    public synchronized String next() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.currentLine)) {
                String string = this.download(this.baseUrl + this.currentLine);
                return string;
            }
            throw new RuntimeException("Iterator has reached the end");
        }
        finally {
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Error obtaining next element " + this.currentLine, e);
            }
        }
    }

    private String download(String url) {
        try {
            GetMethod method = new GetMethod(url);
            int responseCode = this.client.executeMethod((HttpMethod)method);
            if (responseCode == 200) {
                return IOUtils.toString((InputStream)new BufferedInputStream(method.getResponseBodyAsStream()));
            }
            throw new RuntimeException("Error " + responseCode + " dowloading url: " + url);
        }
        catch (IOException e) {
            throw new RuntimeException("Error dowloading url: " + url);
        }
    }

    @Override
    public void remove() {
    }
}

