/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class CollectorPluginEnumerator
implements BeanFactoryAware {
    private ListableBeanFactory beanFactory;

    public Collection<CollectorPlugin> getAll() {
        return this.beanFactory.getBeansOfType(CollectorPlugin.class).values();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public CollectorPlugin get(String protocol) throws CollectorServiceException {
        for (CollectorPlugin cp : this.getAll()) {
            if (!protocol.equalsIgnoreCase(cp.getProtocol())) continue;
            return cp;
        }
        throw new CollectorServiceException("plugin not found for protocol: " + protocol);
    }
}

