/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.archive.targz;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TarGzIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(TarGzIterator.class);
    private TarArchiveInputStream tarInputStream;
    private String current;

    public TarGzIterator(String tarGzPath) {
        try {
            this.tarInputStream = new TarArchiveInputStream((InputStream)new BufferedInputStream(new GZIPInputStream(new FileInputStream(tarGzPath))));
            this.current = this.findNext();
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Tar.gz file not found: " + tarGzPath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Problem opening tar.gz file " + tarGzPath), (Throwable)e);
        }
    }

    public TarGzIterator(File tarGzFile) {
        try {
            this.tarInputStream = new TarArchiveInputStream((InputStream)new BufferedInputStream(new GZIPInputStream(new FileInputStream(tarGzFile))));
            this.current = this.findNext();
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Tar.gz file not found: " + tarGzFile.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Problem opening tar.gz file " + tarGzFile.getAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public String next() {
        String ret = new String(this.current);
        this.current = this.findNext();
        return ret;
    }

    @Override
    public void remove() {
    }

    private synchronized String findNext() {
        TarArchiveEntry entry = null;
        try {
            while (null != (entry = this.tarInputStream.getNextTarEntry()) && !entry.isFile()) {
                log.debug((Object)("Skipping TAR entry " + entry.getName()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error during tar.gz extraction", (Throwable)e);
        }
        if (entry == null) {
            return null;
        }
        log.debug((Object)("Extracting " + entry.getName()));
        byte[] content = new byte[(int)entry.getSize()];
        try {
            this.tarInputStream.read(content, 0, content.length);
            return new String(content);
        }
        catch (IOException e) {
            log.error((Object)("Impossible to extract file " + entry.getName()), (Throwable)e);
            return null;
        }
    }
}

