/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oaisets;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.oaisets.OaiSetsIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Required;

public class OaiSetsCollectorPlugin
extends AbstractCollectorPlugin {
    private OaiSetsIteratorFactory oaiSetsIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return OaiSetsCollectorPlugin.this.oaiSetsIteratorFactory.newIterator(baseUrl);
            }
        };
    }

    public OaiSetsIteratorFactory getOaiSetsIteratorFactory() {
        return this.oaiSetsIteratorFactory;
    }

    @Required
    public void setOaiSetsIteratorFactory(OaiSetsIteratorFactory oaiSetsIteratorFactory) {
        this.oaiSetsIteratorFactory = oaiSetsIteratorFactory;
    }
}

