/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.actors;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.cql.CqlTranslator;
import eu.dnetlib.functionality.index.IndexCollection;
import eu.dnetlib.functionality.index.IndexServerDAO;
import eu.dnetlib.functionality.index.IndexServerDAOMap;
import eu.dnetlib.functionality.index.actors.BlackboardActorCallback;
import eu.dnetlib.functionality.index.actors.IndexFeedActor;
import eu.dnetlib.functionality.index.actors.ResultsetKeepAliveCallback;
import eu.dnetlib.functionality.index.feed.DocumentFeeder;
import eu.dnetlib.functionality.index.feed.DocumentMapperFactory;
import eu.dnetlib.functionality.index.feed.FeedMode;
import eu.dnetlib.functionality.index.feed.FeedResult;
import eu.dnetlib.functionality.index.model.document.IndexDocument;
import eu.dnetlib.functionality.index.utils.IndexDateUtility;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.ServiceTools;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.z3950.zing.cql.CQLParseException;

public class IndexFeedActorImpl
implements IndexFeedActor {
    private static final Log log = LogFactory.getLog(IndexFeedActorImpl.class);
    private final transient IndexServerDAOMap indexServerDAOMap;
    private final transient ServiceTools serviceTools;
    private final transient ExecutorService threadPool = Executors.newCachedThreadPool();
    private CqlTranslator translator;

    public IndexFeedActorImpl(IndexServerDAOMap indexServerDAOMap, ServiceTools serviceTools, CqlTranslator translator) {
        this.indexServerDAOMap = indexServerDAOMap;
        this.serviceTools = serviceTools;
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedIndex(String dsId, FeedMode feedMode, Iterable<String> docIterator, ResultsetKeepAliveCallback startCallback, BlackboardActorCallback endCallback, String backendId, boolean emptyResult) {
        IndexCollection indexCollection = null;
        try {
            startCallback.unschedule();
            MetadataReference mdref = this.serviceTools.getMetadataRef(dsId);
            IndexServerDAO serverDAO = this.indexServerDAOMap.getIndexServerDAO(backendId);
            DocumentMapperFactory docMapperFactory = serverDAO.getDocumentMapperFactory();
            String version = DateUtils.now_ISO8601();
            Function<String, IndexDocument> docMapper = docMapperFactory.getRecordMapper(serverDAO.getSchema(mdref), mdref, dsId, version, emptyResult);
            Iterable result = Iterables.transform(docIterator, docMapper);
            indexCollection = serverDAO.getIndexCollection(mdref);
            FeedResult res = this.threadPool.submit(new DocumentFeeder(indexCollection, result)).get();
            this.cleanMarkedDocuments(indexCollection, dsId);
            if (feedMode.equals((Object)FeedMode.REFRESH)) {
                this.deleteByVersion(indexCollection, dsId, version);
            }
            indexCollection.commit();
            indexCollection.shutdown();
            log.info((Object)("FeedResult: " + res.setTimeElapsed(System.currentTimeMillis())));
            endCallback.setJobDone();
        }
        catch (Exception e) {
            endCallback.setJobFailed(e);
            log.error((Object)"feed index job failed", (Throwable)e);
        }
        finally {
            if (indexCollection != null) {
                indexCollection.shutdown();
            }
        }
    }

    private void deleteByVersion(IndexCollection indexCollection, String dsId, String version) throws IndexServiceException {
        String cqlQuery = "__dsversion < \"" + IndexDateUtility.getParsedDateField(version) + "\"";
        try {
            String luceneQuerty = this.translator.getTranslatedQuery(cqlQuery).asLucene();
            indexCollection.deleteByQuery(luceneQuerty, dsId);
        }
        catch (CQLParseException e) {
            throw new IndexServiceException("Cannot parse CQL query into lucene query: " + cqlQuery, (Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException("Cannot parse CQL query into lucene query: " + cqlQuery, (Throwable)e);
        }
    }

    public void cleanMarkedDocuments(IndexCollection indexCollection, String dsId) throws IndexServiceException {
        String cqlQuery = "__deleted all true ";
        try {
            String luceneQuery = this.translator.getTranslatedQuery("__deleted all true ").asLucene();
            indexCollection.deleteByQuery(luceneQuery, dsId);
        }
        catch (CQLParseException e) {
            throw new IndexServiceException("Cannot parse CQL query into lucene query: __deleted all true ", (Throwable)e);
        }
        catch (IOException e) {
            throw new IndexServiceException("Cannot parse CQL query into lucene query: __deleted all true ", (Throwable)e);
        }
    }
}

