package eu.dnetlib.functionality.index.actors;

import eu.dnetlib.functionality.index.feed.FeedMode;

/**
 * The Interface IndexFeedActor.
 */
public interface IndexFeedActor {

    /**
     * Feed index.
     *
     * @param dsId          the ds id
     * @param feedMode      the feed mode
     * @param docIterator   the doc iterator
     * @param startCallback the start callback
     * @param endCallback   the end callback
     * @param backendId     the backend identifier
     */
    void feedIndex(String dsId,
                   FeedMode feedMode,
                   Iterable<String> docIterator,
                   ResultsetKeepAliveCallback startCallback,
                   BlackboardActorCallback endCallback,
                   final String backendId,
                   boolean emptyResult);

}
