package eu.dnetlib.functionality.index.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

/**
 * The Class IndexDateUtility.
 */
public class IndexDateUtility {

	/** The Constant dateFormats. */
	private final static List<String> dateFormats = Arrays.asList("yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy");

	/** The Constant outFormat. */
	private static final String outFormat = new String("yyyy-MM-dd'T'HH:mm:ss'Z'");

	/**
	 * method return a solr-compatible string representation of a date.
	 * 
	 * @param date
	 *            the date
	 * @return the parsed date field
	 */
	public static String getParsedDateField(final String date) {
		for (String formatString : dateFormats) {
			try {
				return new SimpleDateFormat(outFormat).format(new SimpleDateFormat(formatString).parse(date));
			} catch (ParseException e) {}
		}
		throw new IllegalStateException("unable to parse date: " + date);
	}

}
