/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.actors;

import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ResultsetKeepAliveJob
implements Job {
    private static final Log log = LogFactory.getLog(ResultsetKeepAliveJob.class);
    public static final String JOB_NAME = "resultsetKeepaliveJob";
    public static final String JOB_GROUP = "keepalive";
    private ServiceResolver serviceResolver;
    private EPRUtils eprUtils;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String rsEpr = (String)context.getTrigger().getJobDataMap().get((Object)"resultset_epr");
        W3CEndpointReference epr = this.eprUtils.getEpr(rsEpr);
        ResultSetService resultSet = (ResultSetService)this.getServiceResolver().getService(ResultSetService.class, epr);
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        try {
            log.debug((Object)("\n\n keepalive resultset: " + rsId + " triggerId: " + context.getTrigger().getJobKey().getName() + "\n\n"));
            resultSet.getNumberOfElements(rsId);
        }
        catch (ResultSetException e) {
            log.warn((Object)"couldn't invoke the resultset call to keep-it-alive");
            throw new RuntimeException(e);
        }
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setEprUtils(EPRUtils eprUtils) {
        this.eprUtils = eprUtils;
    }

    public EPRUtils getEprUtils() {
        return this.eprUtils;
    }
}

