/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.index.IndexServerDAO;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractBackendDescriptor
implements IndexServerDAO {
    protected Type typeToken = new TypeToken<Map<String, String>>(){}.getType();
    private Map<String, String> serviceProperties;
    private String jsonConfiguration;

    public void init() throws IndexServiceException {
        try {
            this.serviceProperties = (Map)new Gson().fromJson(this.getJsonConfiguration(), this.typeToken);
        }
        catch (Throwable e) {
            throw new IndexServiceException("unable to parse configuration: " + this.jsonConfiguration, e);
        }
    }

    public String getJsonConfiguration() {
        return this.jsonConfiguration;
    }

    protected URI getEndpointURL() {
        return URI.create(this.getEndpoint().get("address"));
    }

    @Required
    public void setJsonConfiguration(String jsonConfiguration) {
        this.jsonConfiguration = jsonConfiguration;
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    @Override
    public String getBackendId() {
        return this.getServiceProperties().get("id");
    }

    @Override
    public Map<String, String> getEndpoint() {
        return Maps.filterKeys(this.getServiceProperties(), (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return key.equals("id") || key.equals("address");
            }
        });
    }
}

